/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.module;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.Bits;
import org.brackit.xquery.expr.DeclVariable;
import org.brackit.xquery.expr.DefaultCtxItem;
import org.brackit.xquery.expr.DefaultCtxPos;
import org.brackit.xquery.expr.DefaultCtxSize;
import org.brackit.xquery.expr.Variable;
import org.brackit.xquery.xdm.type.SequenceType;

public class Variables {
    protected final Map<QNm, Variable> vars = new TreeMap<QNm, Variable>();
    protected final DefaultCtxItem dftItem = new DefaultCtxItem();
    protected final DefaultCtxPos dftPos = new DefaultCtxPos(this.dftItem);
    protected final DefaultCtxSize dftSize = new DefaultCtxSize(this.dftItem);
    protected LinkedList<Variables> imports = new LinkedList();

    public boolean isDeclared(QNm name) {
        return this.vars.containsKey(name);
    }

    public DefaultCtxItem getDftCtxItem() {
        return this.dftItem;
    }

    public DefaultCtxPos getDftCtxPos() {
        return this.dftPos;
    }

    public DefaultCtxSize getDftCtxSize() {
        return this.dftSize;
    }

    public Variable resolve(QNm name) {
        Variable var = this.vars.get(name);
        if (var != null) {
            return var;
        }
        if (name.equals(Bits.FS_DOT)) {
            return this.dftItem;
        }
        if (name.equals(Bits.FS_POSITION)) {
            return this.dftPos;
        }
        if (name.equals(Bits.FS_LAST)) {
            return var;
        }
        for (Variables v : this.imports) {
            var = v.resolve(name);
            if (v == null) continue;
            return var;
        }
        return null;
    }

    public void importVariables(Variables variables) {
        this.imports.add(variables);
    }

    public DeclVariable declare(QNm name, SequenceType type, boolean external) {
        DeclVariable var = new DeclVariable(name, type);
        this.vars.put(name, var);
        return var;
    }

    public Collection<Variable> getDeclaredVariables() {
        return Collections.unmodifiableCollection(this.vars.values());
    }
}

