/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node;

import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AnyURI;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.node.stream.AtomStream;
import org.brackit.xquery.node.stream.filter.Filter;
import org.brackit.xquery.node.stream.filter.FilteredStream;
import org.brackit.xquery.xdm.AbstractItem;
import org.brackit.xquery.xdm.Axis;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.Type;
import org.brackit.xquery.xdm.node.Node;
import org.brackit.xquery.xdm.type.AttributeType;
import org.brackit.xquery.xdm.type.CommentType;
import org.brackit.xquery.xdm.type.DocumentType;
import org.brackit.xquery.xdm.type.ElementType;
import org.brackit.xquery.xdm.type.ItemType;
import org.brackit.xquery.xdm.type.NodeType;
import org.brackit.xquery.xdm.type.PIType;
import org.brackit.xquery.xdm.type.TextType;

public abstract class AbstractNode<E extends Node<E>>
extends AbstractItem
implements Node<E> {
    @Override
    public Stream<? extends E> getPath() {
        final AbstractNode node = this;
        return new Stream(){
            Node<? extends E> next;
            {
                this.next = node;
            }

            @Override
            public void close() {
            }

            public Object next() {
                if (this.next == null) {
                    return null;
                }
                Node deliver = this.next;
                this.next = deliver.getParent();
                return deliver;
            }
        };
    }

    @Override
    public final int cmp(Node<?> other) {
        int fragmentIDB;
        if (other == this) {
            return 0;
        }
        int fragmentIDA = this.getNodeClassID();
        if (fragmentIDA == (fragmentIDB = other.getNodeClassID())) {
            return this.cmpInternal(other);
        }
        return fragmentIDA < fragmentIDB ? -1 : 1;
    }

    protected abstract int cmpInternal(E var1);

    @Override
    public Stream<? extends E> getDescendantOrSelf() {
        return new FilteredStream(this.getSubtree(), new AttributeFilter());
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return true;
    }

    @Override
    public AnyURI getBaseURI() {
        return null;
    }

    @Override
    public Stream<Atomic> getValues() {
        return new AtomStream<Atomic>(this.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Str getStrValue() {
        if (this.getKind() == Kind.ELEMENT || this.getKind() == Kind.DOCUMENT) {
            StringBuilder buffer = new StringBuilder();
            try (Stream<E> scanner = this.getDescendantOrSelf();){
                Node descendant;
                while ((descendant = (Node)scanner.next()) != null) {
                    if (descendant.getKind() != Kind.TEXT) continue;
                    buffer.append(descendant.getValue());
                }
            }
            return new Str(buffer.toString());
        }
        return this.getValue().asStr();
    }

    @Override
    public Type type() {
        switch (this.getKind()) {
            case ELEMENT: {
                return Type.UN;
            }
            case ATTRIBUTE: 
            case TEXT: {
                return Type.UNA;
            }
        }
        return null;
    }

    @Override
    public ItemType itemType() {
        switch (this.getKind()) {
            case ELEMENT: {
                return new ElementType(this.getName(), Type.UN);
            }
            case ATTRIBUTE: {
                return new AttributeType(this.getName(), Type.UNA);
            }
            case TEXT: {
                return new TextType();
            }
            case COMMENT: {
                return new CommentType();
            }
            case PROCESSING_INSTRUCTION: {
                return new PIType();
            }
            case DOCUMENT: {
                return new DocumentType();
            }
        }
        return null;
    }

    @Override
    public Stream<? extends Node<?>> performStep(Axis axis, NodeType test) {
        return null;
    }

    @Override
    public Atomic atomize() throws QueryException {
        return this.getValue();
    }

    public final boolean equals(Object obj) {
        return obj instanceof Node && this.isSelfOf((Node)obj);
    }

    private static class AttributeFilter
    implements Filter<Node<?>> {
        private AttributeFilter() {
        }

        @Override
        public boolean filter(Node<?> node) {
            return node.getKind() == Kind.ATTRIBUTE;
        }
    }
}

