/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node;

import java.util.Arrays;
import org.brackit.xquery.node.AbstractNodeCollection;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.node.stream.ArrayStream;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.OperationNotSupportedException;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.node.Node;

public class ArrayCollection<E extends Node<E>>
extends AbstractNodeCollection<E> {
    protected Node[] docs;

    public ArrayCollection(String name, E doc) {
        super(name);
        this.docs = new Node[]{doc};
    }

    @SafeVarargs
    public ArrayCollection(String name, E ... docs) {
        super(name);
        this.docs = docs;
    }

    @Override
    public E getDocument() {
        if (this.docs.length == 1) {
            return (E)this.docs[0];
        }
        throw new DocumentException("Illegal access to non-singular collection", new Object[0]);
    }

    @Override
    public Stream<? extends E> getDocuments() {
        return new ArrayStream<Node>(this.docs);
    }

    @Override
    public E add(SubtreeParser parser) {
        throw new OperationNotSupportedException();
    }

    public void add(Node<? super E> doc) {
        this.docs = Arrays.copyOf(this.docs, this.docs.length + 1);
        this.docs[this.docs.length - 1] = doc;
    }

    @Override
    public void delete() {
        throw new OperationNotSupportedException();
    }

    @Override
    public void remove(long documentID) {
        throw new OperationNotSupportedException();
    }

    @Override
    public long getDocumentCount() {
        return this.docs.length;
    }
}

