/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.brackit.xquery.node.d2linked.D2NodeFactory;
import org.brackit.xquery.node.parser.DocumentParser;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.util.io.URIHandler;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.OperationNotSupportedException;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.node.NodeCollection;
import org.brackit.xquery.xdm.node.NodeFactory;
import org.brackit.xquery.xdm.node.NodeStore;

public class SimpleStore
implements NodeStore {
    private final Map<String, NodeCollection<?>> docs = new HashMap();

    @Override
    public NodeCollection<?> create(String name) throws DocumentException {
        NodeCollection<?> coll = this.getNodeFactory().collection(name);
        this.docs.put(name, coll);
        return coll;
    }

    @Override
    public NodeCollection<?> create(String name, SubtreeParser parser) throws DocumentException {
        NodeCollection<?> coll = this.getNodeFactory().collection(name, parser);
        this.docs.put(name, coll);
        return coll;
    }

    @Override
    public NodeCollection<?> create(String name, Stream<SubtreeParser> parsers) throws DocumentException {
        NodeCollection<?> coll = this.getNodeFactory().collection(name, parsers);
        this.docs.put(name, coll);
        return coll;
    }

    @Override
    public void drop(String name) throws DocumentException {
        if (this.docs.remove(name) == null) {
            throw new DocumentException("Collection %s not found", name);
        }
    }

    @Override
    public NodeCollection<?> lookup(String name) throws DocumentException {
        NodeCollection<Object> coll = this.docs.get(name);
        if (coll != null) {
            return coll;
        }
        try {
            InputStream in = URIHandler.getInputStream(URI.create(name));
            DocumentParser p = new DocumentParser(in);
            Object doc = this.getNodeFactory().build(p);
            coll = doc.getCollection();
            this.docs.put(name, coll);
            return coll;
        }
        catch (IOException e) {
            throw new DocumentException((Throwable)e, "Collection %s not found", name);
        }
    }

    protected NodeFactory<?> getNodeFactory() {
        return new D2NodeFactory();
    }

    @Override
    public void makeDir(String path) throws DocumentException {
        throw new OperationNotSupportedException();
    }
}

