/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.d2linked;

import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Una;
import org.brackit.xquery.node.d2linked.D2Node;
import org.brackit.xquery.node.d2linked.D2NodeBuilder;
import org.brackit.xquery.node.d2linked.ElementD2Node;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.OperationNotSupportedException;
import org.brackit.xquery.xdm.node.Node;

public final class AttributeD2Node
extends D2Node {
    QNm name;
    Una value;

    AttributeD2Node(ElementD2Node parent, int[] division, QNm name, Atomic value) throws DocumentException {
        super(parent, division);
        this.name = this.checkName(name);
        this.value = value.asUna();
    }

    AttributeD2Node(ElementD2Node parent, QNm name, Atomic value) throws DocumentException {
        this(parent, FIRST, name, value);
    }

    public AttributeD2Node(QNm name, Atomic value) throws DocumentException {
        this(null, FIRST, name, value);
    }

    private QNm checkName(QNm name) throws DocumentException {
        if (name.getPrefix() == null || this.parent == null) {
            return name;
        }
        return ((ElementD2Node)this.parent).checkName(name);
    }

    @Override
    public QNm getName() throws DocumentException {
        return this.name;
    }

    @Override
    public Atomic getValue() {
        return this.value;
    }

    @Override
    public void setName(QNm name) throws OperationNotSupportedException, DocumentException {
        this.name = this.checkName(name);
    }

    @Override
    public void setValue(Atomic value) throws OperationNotSupportedException, DocumentException {
        this.value = value.asUna();
    }

    @Override
    public Kind getKind() {
        return Kind.ATTRIBUTE;
    }

    @Override
    public boolean isChildOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isAttributeOf(Node<?> node) {
        return this.parent != null && this.parent == node;
    }

    @Override
    public boolean isDescendantOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isDescendantOrSelfOf(Node<?> node) {
        return node != null && this == node;
    }

    @Override
    public boolean isFollowingOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isFollowingSiblingOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isPrecedingOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isPrecedingSiblingOf(Node<?> node) {
        return false;
    }

    @Override
    public boolean isSiblingOf(Node<?> node) {
        return false;
    }

    @Override
    public D2Node replaceWith(Kind kind, QNm name, Atomic value) throws OperationNotSupportedException, DocumentException {
        if (kind != Kind.ATTRIBUTE) {
            throw new DocumentException("Cannot replace attribute with node of type: %s.", new Object[]{kind});
        }
        if (this.parent == null) {
            throw new DocumentException("Cannot replace node without parent", new Object[0]);
        }
        return this.parent.setAttribute(name, value);
    }

    @Override
    public D2Node replaceWith(Node<?> node) throws OperationNotSupportedException, DocumentException {
        Kind kind = node.getKind();
        if (kind != Kind.ATTRIBUTE) {
            throw new DocumentException("Cannot replace attribute with node of type: %s.", new Object[]{kind});
        }
        if (this.parent == null) {
            throw new DocumentException("Cannot replace node without parent", new Object[0]);
        }
        return this.parent.setAttribute(this.name, this.value);
    }

    @Override
    public D2Node replaceWith(SubtreeParser parser) throws OperationNotSupportedException, DocumentException {
        D2NodeBuilder builder = new D2NodeBuilder(){

            @Override
            D2Node first(Kind kind, QNm name, Atomic value) throws DocumentException {
                if (kind != Kind.ATTRIBUTE) {
                    throw new DocumentException("Cannot replace attribute with node of type: %s.", new Object[]{kind});
                }
                if (AttributeD2Node.this.parent == null) {
                    throw new DocumentException("Cannot replace node without parent", new Object[0]);
                }
                return AttributeD2Node.this.parent.setAttribute(name, value);
            }
        };
        parser.parse(builder);
        return (D2Node)builder.root();
    }

    @Override
    public D2Node getPreviousSibling() throws DocumentException {
        return null;
    }

    @Override
    public D2Node getNextSibling() throws DocumentException {
        return null;
    }

    @Override
    public D2Node append(Kind kind, QNm name, Atomic value) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node append(Node<?> child) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node append(SubtreeParser parser) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertAfter(Kind kind, QNm name, Atomic value) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertAfter(Node<?> node) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertAfter(SubtreeParser parser) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertBefore(Kind kind, QNm name, Atomic value) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertBefore(Node<?> node) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node insertBefore(SubtreeParser parser) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node prepend(Kind kind, QNm name, Atomic value) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node prepend(Node<?> child) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    @Override
    public D2Node prepend(SubtreeParser parser) throws OperationNotSupportedException, DocumentException {
        throw new OperationNotSupportedException();
    }

    public String toString() {
        return String.format("(type='%s', name='%s', value='%s')", new Object[]{Kind.ATTRIBUTE, this.name, this.value});
    }
}

