/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.d2linked;

import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.node.d2linked.D2Node;
import org.brackit.xquery.node.d2linked.ParentD2Node;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.OperationNotSupportedException;

public final class CommentD2Node
extends D2Node {
    private Str value;

    public CommentD2Node(Atomic value) throws DocumentException {
        this(null, FIRST, value);
    }

    CommentD2Node(ParentD2Node parent, int[] division, Atomic value) throws DocumentException {
        super(parent, division);
        this.value = this.checkValue(value);
    }

    private Str checkValue(Atomic v) throws DocumentException {
        String s = v.stringValue();
        if (s.contains("--")) {
            throw new DocumentException("Character sequence \"--\" is not allowed in comment content", new Object[0]);
        }
        if (s.endsWith("-")) {
            throw new DocumentException("Comment content must not end with \"-\"", new Object[0]);
        }
        return v.asStr();
    }

    @Override
    public Kind getKind() {
        return Kind.COMMENT;
    }

    @Override
    public QNm getName() throws DocumentException {
        return null;
    }

    @Override
    public Atomic getValue() {
        return this.value;
    }

    @Override
    public void setValue(Atomic value) throws OperationNotSupportedException, DocumentException {
        this.value = this.checkValue(value);
    }

    @Override
    public D2Node getNextSibling() throws DocumentException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.nextSiblingOf(this);
    }

    @Override
    public D2Node getPreviousSibling() throws DocumentException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.previousSiblingOf(this);
    }

    public String toString() {
        return String.format("(type='%s', name='', value='%s')", new Object[]{Kind.COMMENT, this.value});
    }
}

