/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.d2linked;

import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.node.d2linked.AttributeD2Node;
import org.brackit.xquery.node.d2linked.CommentD2Node;
import org.brackit.xquery.node.d2linked.D2Node;
import org.brackit.xquery.node.d2linked.D2NodeBuilder;
import org.brackit.xquery.node.d2linked.D2NodeCollection;
import org.brackit.xquery.node.d2linked.DocumentD2Node;
import org.brackit.xquery.node.d2linked.ElementD2Node;
import org.brackit.xquery.node.d2linked.PID2Node;
import org.brackit.xquery.node.d2linked.TextD2Node;
import org.brackit.xquery.node.parser.NavigationalSubtreeParser;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.node.Node;
import org.brackit.xquery.xdm.node.NodeCollection;
import org.brackit.xquery.xdm.node.NodeFactory;

public class D2NodeFactory
implements NodeFactory<D2Node> {
    @Override
    public D2Node attribute(QNm name, Atomic value) throws DocumentException {
        return new AttributeD2Node(name, value);
    }

    @Override
    public D2Node comment(Str value) throws DocumentException {
        return new CommentD2Node(value);
    }

    @Override
    public D2Node document(Str name) throws DocumentException {
        String s = name != null ? name.stringValue() : null;
        return new DocumentD2Node(s);
    }

    @Override
    public D2Node element(QNm name) throws DocumentException {
        return new ElementD2Node(name);
    }

    @Override
    public D2Node pi(QNm target, Str value) throws DocumentException {
        return new PID2Node(target, value);
    }

    @Override
    public D2Node text(Atomic value) throws DocumentException {
        return new TextD2Node(value);
    }

    @Override
    public D2Node copy(Node<?> source) throws DocumentException {
        return this.build(new NavigationalSubtreeParser(source));
    }

    @Override
    public D2Node build(SubtreeParser parser) throws DocumentException {
        D2NodeBuilder handler = new D2NodeBuilder();
        parser.parse(handler);
        return (D2Node)handler.root();
    }

    @Override
    public NodeCollection<D2Node> collection(String name, SubtreeParser parser) throws DocumentException {
        D2NodeCollection coll = new D2NodeCollection(name);
        D2NodeBuilder builder = new D2NodeBuilder(coll);
        parser.parse(builder);
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeCollection<D2Node> collection(String name, Stream<SubtreeParser> parsers) throws DocumentException {
        D2NodeCollection coll = new D2NodeCollection(name);
        D2NodeBuilder builder = new D2NodeBuilder(coll);
        try {
            SubtreeParser parser;
            while ((parser = parsers.next()) != null) {
                parser.parse(builder);
            }
        }
        finally {
            parsers.close();
        }
        return coll;
    }

    @Override
    public NodeCollection<D2Node> collection(String name) throws DocumentException {
        return new D2NodeCollection(name);
    }
}

