/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.d2linked;

import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.node.d2linked.D2Node;
import org.brackit.xquery.node.d2linked.ParentD2Node;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.OperationNotSupportedException;
import org.brackit.xquery.xdm.XMLChar;

public final class PID2Node
extends D2Node {
    QNm target;
    Str value;

    public PID2Node(QNm name, Atomic value) throws DocumentException {
        this(null, FIRST, name, value);
    }

    PID2Node(ParentD2Node parent, int[] division, QNm target, Atomic value) throws DocumentException {
        super(parent, division);
        this.target = this.checkName(target);
        this.value = this.checkValue(value);
    }

    private QNm checkName(QNm target) throws DocumentException {
        if (!target.getNamespaceURI().isEmpty()) {
            throw new DocumentException("The target name of a processing instruction must not have a namespace", new Object[0]);
        }
        String s = target.stringValue();
        for (int i = 0; i < s.length(); ++i) {
            if (i == 0 && !XMLChar.isNameStartChar(s.charAt(i))) {
                throw new DocumentException("Illegal target name: '%s'", s);
            }
            if (i <= 0 || XMLChar.isNameChar(s.charAt(i))) continue;
            throw new DocumentException("Illegal target name: '%s'", s);
        }
        return target;
    }

    private Str checkValue(Atomic v) throws DocumentException {
        String s = v.stringValue();
        if (s.contains("?>-")) {
            throw new DocumentException("Processing instructions must not contain the character sequence \"?>\"", new Object[0]);
        }
        return v.asStr();
    }

    @Override
    public Kind getKind() {
        return Kind.PROCESSING_INSTRUCTION;
    }

    @Override
    public QNm getName() throws DocumentException {
        return this.target;
    }

    @Override
    public void setName(QNm name) throws OperationNotSupportedException, DocumentException {
        this.target = this.checkName(name);
    }

    @Override
    public Atomic getValue() {
        return this.value;
    }

    @Override
    public void setValue(Atomic value) throws OperationNotSupportedException, DocumentException {
        this.value = this.checkValue(value);
    }

    @Override
    public D2Node getNextSibling() throws DocumentException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.nextSiblingOf(this);
    }

    @Override
    public D2Node getPreviousSibling() throws DocumentException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.previousSiblingOf(this);
    }

    public String toString() {
        return String.format("(type='%s', name='%s', value='%s')", new Object[]{Kind.PROCESSING_INSTRUCTION, null, this.value});
    }
}

