/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.dom;

import java.util.ArrayDeque;
import java.util.Deque;
import org.brackit.xquery.node.dom.AttrImpl;
import org.brackit.xquery.node.dom.CommentImpl;
import org.brackit.xquery.node.dom.DocumentImpl;
import org.brackit.xquery.node.dom.ElementImpl;
import org.brackit.xquery.node.dom.NodeImpl;
import org.brackit.xquery.node.dom.ProcInstrImpl;
import org.brackit.xquery.node.dom.TextImpl;
import org.brackit.xquery.node.parser.DefaultListener;
import org.brackit.xquery.node.parser.SubtreeListener;
import org.brackit.xquery.xdm.DocumentException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMListener
extends DefaultListener<org.brackit.xquery.xdm.node.Node<?>>
implements SubtreeListener<org.brackit.xquery.xdm.node.Node<?>> {
    protected DocumentImpl document;
    protected final Deque<NodeImpl> stack = new ArrayDeque<NodeImpl>();

    @Override
    public void startDocument() throws DocumentException {
        if (this.document != null) {
            throw new DocumentException("Multiple documents are not supported", new Object[0]);
        }
        this.document = new DocumentImpl();
        this.stack.clear();
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public <T extends org.brackit.xquery.xdm.node.Node<?>> void attribute(T node) throws DocumentException {
        Node current = this.stack.peekLast();
        ((Element)current).setAttributeNode(new AttrImpl(this.document, current, node.getName().stringValue(), node.getValue().stringValue()));
    }

    @Override
    public <T extends org.brackit.xquery.xdm.node.Node<?>> void startElement(T node) throws DocumentException {
        NodeImpl current = this.stack.peekLast();
        ElementImpl newChild = new ElementImpl(this.document, current, node.getName().stringValue(), null);
        if (current != null) {
            ((Element)((Object)current)).appendChild(newChild);
        } else {
            this.document.setDocumentElement(newChild);
        }
        this.stack.addLast(newChild);
    }

    @Override
    public <T extends org.brackit.xquery.xdm.node.Node<?>> void endElement(T node) throws DocumentException {
        this.stack.pop();
    }

    @Override
    public <T extends org.brackit.xquery.xdm.node.Node<?>> void text(T node) throws DocumentException {
        this.insertText(node.getValue().stringValue());
    }

    @Override
    public <T extends org.brackit.xquery.xdm.node.Node<?>> void comment(T node) throws DocumentException {
        this.insertComment(node.getValue().stringValue());
    }

    @Override
    public <T extends org.brackit.xquery.xdm.node.Node<?>> void processingInstruction(T node) throws DocumentException {
        this.insertProcessingInstruction(node.getValue().stringValue());
    }

    private void insertText(String text) throws DocumentException {
        NodeImpl current = this.stack.peekLast();
        current.appendChild(new TextImpl(this.document, current, null, text));
    }

    private void insertProcessingInstruction(String value) {
        NodeImpl current = this.stack.peekLast();
        current.appendChild(new ProcInstrImpl(this.document, current, null, value));
    }

    private void insertComment(String value) {
        NodeImpl current = this.stack.peekLast();
        current.appendChild(new CommentImpl(this.document, current, null, value));
    }
}

