/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.brackit.xquery.node.dom.NamedNodeMapImpl;
import org.brackit.xquery.node.dom.NodeListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NodeImpl
implements Node {
    protected short type;
    protected String name;
    protected String value;
    protected Node parent;
    protected Node nextSibling;
    protected Node previousSibling;
    protected Document document;
    protected List<Node> children;
    protected Map<String, Attr> attributes;

    public NodeImpl(Document document, Node parent, short type, String name, String value) {
        this.document = document;
        this.parent = parent;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (this.children == null) {
            this.children = new ArrayList<Node>(3);
        }
        this.children.add(newChild);
        return newChild;
    }

    @Override
    public Node cloneNode(boolean deep) {
        NodeImpl clone = null;
        try {
            clone = (NodeImpl)this.clone();
            if (deep) {
                if (this.children != null) {
                    ArrayList<Node> clonedChildren = new ArrayList<Node>(this.children.size());
                    for (Node node : this.children) {
                        clonedChildren.add(node.cloneNode(deep));
                    }
                    clone.children = clonedChildren;
                }
                if (this.attributes != null) {
                    TreeMap<String, Attr> clonedAttributes = new TreeMap<String, Attr>();
                    for (Map.Entry entry : this.attributes.entrySet()) {
                        clonedAttributes.put((String)entry.getKey(), (Attr)((Attr)entry.getValue()).cloneNode(deep));
                    }
                    clone.attributes = clonedAttributes;
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new RuntimeException();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new NamedNodeMapImpl(this.attributes);
    }

    @Override
    public String getBaseURI() {
        throw new RuntimeException();
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeListImpl(this.children);
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new RuntimeException();
    }

    @Override
    public Node getFirstChild() {
        return this.children != null ? this.children.get(0) : null;
    }

    @Override
    public Node getLastChild() {
        return this.children != null ? this.children.get(this.children.size() - 1) : null;
    }

    @Override
    public String getLocalName() {
        return this.name;
    }

    @Override
    public String getNamespaceURI() {
        throw new RuntimeException();
    }

    @Override
    public Node getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public short getNodeType() {
        return this.type;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.value;
    }

    @Override
    public Document getOwnerDocument() {
        return this.document;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public String getPrefix() {
        throw new RuntimeException();
    }

    @Override
    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public String getTextContent() throws DOMException {
        throw new RuntimeException();
    }

    @Override
    public Object getUserData(String key) {
        throw new RuntimeException();
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.children != null;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new RuntimeException();
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new RuntimeException();
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new RuntimeException();
    }

    @Override
    public boolean isSameNode(Node other) {
        throw new RuntimeException();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        throw new RuntimeException();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new RuntimeException();
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new RuntimeException();
    }

    @Override
    public void normalize() {
        throw new RuntimeException();
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw new RuntimeException();
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new RuntimeException();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.value = nodeValue;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new RuntimeException();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new RuntimeException();
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new RuntimeException();
    }

    public String toString() {
        return String.format("%s(type=%s name=%s value=%s)", this.type, this.name, this.value);
    }
}

