/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.parser;

import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.node.parser.SubtreeHandler;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.node.stream.ArrayStream;
import org.brackit.xquery.node.stream.AtomStream;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Stream;

public class CollectionParser
implements SubtreeParser {
    private final Stream<SubtreeParser> parsers;

    public CollectionParser(Stream<SubtreeParser> parsers) {
        this.parsers = parsers;
    }

    public CollectionParser(SubtreeParser parser) {
        this.parsers = new AtomStream<SubtreeParser>(parser);
    }

    public CollectionParser(SubtreeParser[] parsers) {
        this.parsers = new ArrayStream<SubtreeParser>(parsers);
    }

    @Override
    public void parse(SubtreeHandler handler) throws DocumentException {
        CollectionHandler collHandler = new CollectionHandler(handler);
        handler.begin();
        SubtreeParser current = null;
        while ((current = this.parsers.next()) != null) {
            current.parse(collHandler);
        }
        this.parsers.close();
        handler.end();
    }

    private class CollectionHandler
    implements SubtreeHandler {
        private final SubtreeHandler handler;
        private int level;

        public CollectionHandler(SubtreeHandler handler) {
            this.handler = handler;
            this.level = 0;
        }

        @Override
        public void attribute(QNm name, Atomic value) throws DocumentException {
            if (this.level == 0) {
                throw new DocumentException("Attribute on top level!", new Object[0]);
            }
            this.handler.attribute(name, value);
        }

        @Override
        public void begin() throws DocumentException {
        }

        @Override
        public void beginFragment() throws DocumentException {
            this.handler.beginFragment();
        }

        @Override
        public void comment(Atomic content) throws DocumentException {
            if (this.level == 0) {
                throw new DocumentException("Comment on top level!", new Object[0]);
            }
            this.handler.comment(content);
        }

        @Override
        public void end() throws DocumentException {
        }

        @Override
        public void endDocument() throws DocumentException {
            this.handler.endDocument();
        }

        @Override
        public void endElement(QNm name) throws DocumentException {
            this.handler.endElement(name);
            --this.level;
            if (this.level == 0) {
                this.handler.endDocument();
            }
        }

        @Override
        public void endFragment() throws DocumentException {
            this.handler.endFragment();
        }

        @Override
        public void endMapping(String prefix) throws DocumentException {
            this.handler.endMapping(prefix);
        }

        @Override
        public void fail() throws DocumentException {
            this.handler.fail();
        }

        @Override
        public void processingInstruction(QNm target, Atomic content) throws DocumentException {
            if (this.level == 0) {
                throw new DocumentException("Processing instruction on top level!", new Object[0]);
            }
            this.handler.processingInstruction(target, content);
        }

        @Override
        public void startDocument() throws DocumentException {
            this.handler.startDocument();
        }

        @Override
        public void startElement(QNm name) throws DocumentException {
            if (this.level == 0) {
                this.handler.startDocument();
            }
            ++this.level;
            this.handler.startElement(name);
        }

        @Override
        public void startMapping(String prefix, String uri) throws DocumentException {
            this.handler.startMapping(prefix, uri);
        }

        @Override
        public void text(Atomic content) throws DocumentException {
            if (this.level == 0) {
                throw new DocumentException("Text on top level!", new Object[0]);
            }
            this.handler.text(content);
        }
    }
}

