/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.parser;

import java.util.ArrayDeque;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Una;
import org.brackit.xquery.node.d2linked.D2NodeFactory;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.node.Node;

public class FragmentHelper {
    private final ArrayDeque<Node<?>> stack = new ArrayDeque();
    private Node<?> root;

    public Node<?> getRoot() {
        return this.root;
    }

    public FragmentHelper openElement(String name) throws DocumentException {
        return this.openElement(new QNm(name));
    }

    public FragmentHelper openElement(QNm name) throws DocumentException {
        if (!this.stack.isEmpty()) {
            this.stack.push((Node<?>)this.stack.peek().append(Kind.ELEMENT, name, null));
        } else {
            this.root = new D2NodeFactory().element(name);
            this.stack.push(this.root);
        }
        return this;
    }

    public FragmentHelper closeElement() throws DocumentException {
        if (this.stack.isEmpty()) {
            throw new DocumentException("No element opened", new Object[0]);
        }
        this.stack.pop();
        return this;
    }

    public FragmentHelper element(String name) throws DocumentException {
        return this.element(new QNm(name));
    }

    public FragmentHelper element(QNm name) throws DocumentException {
        this.openElement(name);
        this.closeElement();
        return this;
    }

    public FragmentHelper attribute(String name, String value) throws DocumentException {
        return this.attribute(new QNm(name), new Una(value));
    }

    public FragmentHelper attribute(QNm name, Atomic value) throws DocumentException {
        if (this.stack.isEmpty() || this.stack.peek().getKind() != Kind.ELEMENT) {
            throw new DocumentException("No element on stack.", new Object[0]);
        }
        Node<?> element = this.stack.peek();
        element.setAttribute(name, value);
        return this;
    }

    public FragmentHelper content(String content) throws DocumentException {
        return this.content(new Una(content));
    }

    public FragmentHelper content(Atomic content) throws DocumentException {
        if (this.stack.isEmpty() || this.stack.peek().getKind() != Kind.ELEMENT) {
            throw new DocumentException("No element on stack.", new Object[0]);
        }
        Node<?> element = this.stack.peek();
        element.append(Kind.TEXT, null, content);
        return this;
    }

    public FragmentHelper insert(Node<?> node) throws DocumentException {
        if (!this.stack.isEmpty()) {
            if (this.stack.peek().getKind() != Kind.ELEMENT) {
                throw new DocumentException("No element on stack.", new Object[0]);
            }
            Node<?> element = this.stack.peek();
            element.append(node);
        } else if (node.getKind() == Kind.ELEMENT) {
            this.root = new D2NodeFactory().element(node.getName());
            this.stack.push(this.root);
        } else {
            throw new DocumentException("Unexpected node type '%s'", new Object[]{node.getKind()});
        }
        return this;
    }
}

