/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.parser;

import java.util.List;
import org.brackit.xquery.node.parser.SubtreeListener;
import org.brackit.xquery.node.parser.SubtreeProcessor;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.node.Node;

public class NavigationalSubtreeProcessor<E extends Node<E>>
extends SubtreeProcessor<E> {
    private final E root;

    public NavigationalSubtreeProcessor(E root, List<SubtreeListener<? super E>> listeners) {
        super(listeners);
        this.root = root;
    }

    public void process() throws DocumentException {
        try {
            this.notifyBegin();
            this.notifyBeginFragment();
            this.traverse(this.root);
            this.notifyEndFragment();
            this.notifyEnd();
        }
        catch (DocumentException e) {
            this.notifyFail();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverse(E node) throws DocumentException {
        Kind kind = node.getKind();
        if (kind == Kind.ELEMENT) {
            this.notifyStartElement(node);
            try (Stream attributeStream = node.getAttributes();){
                Node attribute;
                while ((attribute = (Node)attributeStream.next()) != null) {
                    this.notifyAttribute(attribute);
                }
            }
            try (Stream childStream = node.getChildren();){
                Node child;
                while ((child = (Node)childStream.next()) != null) {
                    this.traverse(child);
                }
            }
            this.notifyEndElement(node);
        } else if (kind == Kind.TEXT) {
            this.notifyText(node);
        } else if (kind == Kind.COMMENT) {
            this.notifyComment(node);
        } else if (kind == Kind.PROCESSING_INSTRUCTION) {
            this.notifyProcessingInstruction(node);
        } else if (kind == Kind.ATTRIBUTE) {
            this.notifyAttribute(node);
        } else if (kind == Kind.DOCUMENT) {
            this.notifyBeginDocument();
            try (Stream childStream = node.getChildren();){
                Node child;
                while ((child = (Node)childStream.next()) != null) {
                    this.traverse(child);
                }
            }
            this.notifyEndDocument();
        } else {
            throw new DocumentException("Illegal node type: %s", new Object[]{kind});
        }
    }
}

