/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.parser;

import java.io.IOException;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.node.parser.DocumentParser;
import org.brackit.xquery.node.parser.StreamSubtreeParser;
import org.brackit.xquery.node.parser.SubtreeParser;
import org.brackit.xquery.util.io.URIHandler;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.node.Node;

public class ParserStream
implements Stream<SubtreeParser> {
    Iter it;

    public ParserStream(Sequence locs) {
        this.it = locs.iterate();
    }

    @Override
    public SubtreeParser next() throws DocumentException {
        try {
            Item i = this.it.next();
            if (i == null) {
                return null;
            }
            if (i instanceof Atomic) {
                String s = ((Atomic)i).stringValue();
                return new DocumentParser(URIHandler.getInputStream(s));
            }
            if (i instanceof Node) {
                Node n = (Node)i;
                return new StreamSubtreeParser(n.getSubtree());
            }
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot create subtree parser for item of type: %s", i.itemType());
        }
        catch (IOException e) {
            throw new DocumentException(e);
        }
        catch (QueryException e) {
            throw new DocumentException(e);
        }
    }

    @Override
    public void close() {
        this.it.close();
    }
}

