/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RelativeEntityResolver
implements EntityResolver {
    private final String baseDir;

    public RelativeEntityResolver(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null && systemId.startsWith("file://")) {
            String targetFile = systemId.substring(7);
            File target = new File(targetFile);
            if (target.exists()) {
                return new InputSource(new FileInputStream(target));
            }
            String curDir = System.getProperty("user.dir");
            if (targetFile.startsWith(curDir) && (target = new File(this.baseDir + System.getProperty("file.separator") + targetFile.substring(curDir.length()))).exists()) {
                return new InputSource(new FileInputStream(target));
            }
        }
        return null;
    }
}

