/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.parser;

import java.util.List;
import org.brackit.xquery.node.parser.SubtreeListener;
import org.brackit.xquery.node.parser.SubtreeProcessor;
import org.brackit.xquery.util.log.Logger;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Stream;
import org.brackit.xquery.xdm.node.Node;

public class StreamSubtreeProcessor<E extends Node<E>>
extends SubtreeProcessor<E> {
    private static final Logger log = Logger.getLogger(StreamSubtreeProcessor.class);
    private boolean displayNodeIDs;
    private final Stream<? extends E> scanner;

    public StreamSubtreeProcessor(Stream<? extends E> scanner, List<SubtreeListener<? super E>> listeners) {
        super(listeners);
        this.scanner = scanner;
    }

    public void process() throws DocumentException {
        try {
            Node[] stack = new Node[10];
            int stackSize = 0;
            Node node = null;
            this.notifyBegin();
            while ((node = (Node)this.scanner.next()) != null) {
                Kind kind;
                if (stackSize == 0) {
                    this.notifyBeginFragment();
                }
                if ((kind = node.getKind()) != Kind.ATTRIBUTE) {
                    while (stackSize > 0 && !stack[stackSize - 1].isParentOf(node)) {
                        Node ancestor;
                        if ((ancestor = stack[--stackSize]).getKind() == Kind.ELEMENT) {
                            this.notifyEndElement(ancestor);
                            continue;
                        }
                        this.notifyEndDocument();
                    }
                }
                if (kind == Kind.ELEMENT) {
                    this.notifyStartElement(node);
                    if (stackSize == stack.length) {
                        newElementStack = new Node[stackSize * 3 / 2 + 1];
                        System.arraycopy(stack, 0, newElementStack, 0, stackSize);
                        stack = newElementStack;
                    }
                    stack[stackSize++] = node;
                } else if (kind == Kind.ATTRIBUTE) {
                    this.notifyAttribute(node);
                } else if (kind == Kind.TEXT) {
                    this.notifyText(node);
                } else if (kind == Kind.COMMENT) {
                    this.notifyComment(node);
                } else if (kind == Kind.PROCESSING_INSTRUCTION) {
                    this.notifyProcessingInstruction(node);
                } else if (kind == Kind.DOCUMENT) {
                    this.notifyBeginDocument();
                    if (stackSize == stack.length) {
                        newElementStack = new Node[stackSize * 3 / 2 + 1];
                        System.arraycopy(stack, 0, newElementStack, 0, stackSize);
                        stack = newElementStack;
                    }
                    stack[stackSize++] = node;
                }
                if (stackSize != 0) continue;
                this.notifyEndFragment();
            }
            while (stackSize > 0) {
                Node ancestor;
                if ((ancestor = stack[--stackSize]).getKind() == Kind.ELEMENT) {
                    this.notifyEndElement(ancestor);
                } else {
                    this.notifyEndDocument();
                }
                if (stackSize != 0) continue;
                this.notifyEndFragment();
            }
            this.notifyEnd();
        }
        catch (Exception e) {
            this.notifyFail();
            log.error(e);
            throw new DocumentException(e);
        }
        finally {
            this.scanner.close();
        }
    }
}

