/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.parser;

import java.util.ArrayList;
import java.util.List;
import org.brackit.xquery.node.parser.SubtreeListener;
import org.brackit.xquery.util.log.Logger;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.node.Node;

public abstract class SubtreeProcessor<E extends Node<E>> {
    private static final Logger log = Logger.getLogger(SubtreeProcessor.class);
    private final List<SubtreeListener<? super E>> listeners = new ArrayList<SubtreeListener<? super E>>();

    public SubtreeProcessor(List<SubtreeListener<? super E>> listeners) {
        if (listeners != null) {
            for (SubtreeListener<E> subtreeListener : listeners) {
                this.listeners.add(subtreeListener);
            }
        }
    }

    protected void notifyBegin() throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.begin();
        }
    }

    protected void notifyEnd() throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.end();
        }
    }

    protected void notifyBeginDocument() throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.startDocument();
        }
    }

    protected void notifyEndDocument() throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.endDocument();
        }
    }

    protected void notifyBeginFragment() throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.beginFragment();
        }
    }

    protected void notifyEndFragment() throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.endFragment();
        }
    }

    protected void notifyFail() {
        for (SubtreeListener<E> listener : this.listeners) {
            try {
                listener.fail();
            }
            catch (DocumentException e) {
                log.error(e);
            }
        }
    }

    protected void notifyStartElement(E node) throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.startElement(node);
        }
    }

    protected void notifyEndElement(E node) throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.endElement(node);
        }
    }

    protected void notifyAttribute(E node) throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.attribute(node);
        }
    }

    protected void notifyText(E node) throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.text(node);
        }
    }

    protected void notifyComment(E node) throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.comment(node);
        }
    }

    protected void notifyProcessingInstruction(E node) throws DocumentException {
        for (SubtreeListener<E> listener : this.listeners) {
            listener.processingInstruction(node);
        }
    }
}

