/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.stream;

import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Stream;

public class ParallelArrayBlockStream<E>
implements Stream<E> {
    private final Stream<? extends E> stream;
    private volatile boolean finished;
    private volatile DocumentException error;
    private Object[] currentBuffer;
    private Object[][] freeQueue;
    private volatile int freeQueueStart;
    private volatile int freeQueueEnd;
    private int pos = 0;

    public ParallelArrayBlockStream(Stream<? extends E> stream) {
        this.stream = stream;
        int noOfBuffers = 3;
        this.freeQueue = new Object[noOfBuffers][2000];
        this.finished = false;
        this.freeQueueStart = noOfBuffers - 1;
        this.freeQueueEnd = 0;
        new Thread(){

            @Override
            public void run() {
                ParallelArrayBlockStream.this.fill();
            }
        }.start();
    }

    private void fill() {
        try {
            E e;
            int pos = 0;
            Object[] buffer = this.freeQueue[0];
            int length = buffer.length;
            while ((e = this.stream.next()) != null) {
                buffer[pos++] = e;
                if (pos != length) continue;
                buffer = this.enqueue();
                length = buffer.length;
                pos = 0;
            }
            this.enqueue();
            this.finished = true;
            this.stream.close();
        }
        catch (DocumentException e) {
            this.error = e;
            this.finished = true;
        }
    }

    private Object[] enqueue() {
        int queueStart = this.freeQueueStart;
        int queueEnd = this.freeQueueEnd;
        int newQueueEnd = (queueEnd + 1) % this.freeQueue.length;
        while (newQueueEnd == queueStart) {
            queueStart = this.freeQueueStart;
        }
        this.freeQueueEnd = newQueueEnd;
        return this.freeQueue[newQueueEnd];
    }

    private Object[] dequeue() {
        int queueStart = this.freeQueueStart;
        int queueEnd = this.freeQueueEnd;
        int newQueueStart = (queueStart + 1) % this.freeQueue.length;
        while (newQueueStart == queueEnd) {
            queueEnd = this.freeQueueEnd;
        }
        this.freeQueueStart = newQueueStart;
        return this.freeQueue[newQueueStart];
    }

    @Override
    public void close() {
        this.finished = true;
    }

    @Override
    public E next() throws DocumentException {
        DocumentException deliverError = this.error;
        if (deliverError != null) {
            this.error = null;
            throw deliverError;
        }
        if (this.currentBuffer == null || this.pos == this.currentBuffer.length) {
            this.currentBuffer = this.dequeue();
            this.pos = 0;
        }
        Object current = this.currentBuffer[this.pos];
        this.currentBuffer[this.pos++] = null;
        return (E)current;
    }
}

