/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.node.stream;

import org.brackit.xquery.node.stream.ParallelArrayBlockStream;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Stream;

public class TestParallelStream {
    public static void main(String[] args) throws Exception {
        Integer next;
        int count = 100000000;
        IntegerStream stream = new IntegerStream(count);
        ParallelArrayBlockStream<Integer> outer = new ParallelArrayBlockStream<Integer>(stream);
        int previous = 0;
        while ((next = (Integer)outer.next()) != null) {
            if (next != previous + 1) {
                throw new Exception(next + " != " + previous + " + 1");
            }
            ++previous;
        }
        outer.close();
        if (previous != count) {
            throw new Exception("Stopped to early: " + previous + " != " + count);
        }
    }

    private static class IntegerStream
    implements Stream<Integer> {
        final int max;
        int current;

        public IntegerStream(int max) {
            this.max = max;
        }

        @Override
        public void close() {
        }

        @Override
        public Integer next() throws DocumentException {
            return this.current < this.max ? Integer.valueOf(++this.current) : null;
        }
    }
}

