/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.operator;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.operator.Check;
import org.brackit.xquery.operator.Cursor;
import org.brackit.xquery.operator.Operator;
import org.brackit.xquery.xdm.Sequence;

public class Count
extends Check
implements Operator {
    private final Operator in;
    private boolean bind = true;

    public Count(Operator in) {
        this.in = in;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) {
        return this.bind ? new CountCursor(this.in.create(ctx, tuple)) : this.in.create(ctx, tuple);
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) {
        return this.bind ? new CountCursor(this.in.create(ctx, buf, len)) : this.in.create(ctx, buf, len);
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.in.tupleWidth(initSize) + 1;
    }

    public void bind(boolean bind) {
        this.bind = bind;
    }

    private class CountCursor
    implements Cursor {
        private final Cursor c;
        private IntNumeric pos;
        private Tuple t;

        public CountCursor(Cursor c) {
            this.c = c;
        }

        @Override
        public void close(QueryContext ctx) {
            this.c.close(ctx);
        }

        @Override
        public Tuple next(QueryContext ctx) {
            Tuple prev = this.t;
            this.t = this.c.next(ctx);
            if (this.t == null) {
                return null;
            }
            if (Count.this.check) {
                if (Count.this.dead(this.t)) {
                    this.pos = Int32.ZERO;
                    return this.t.concat((Sequence)null);
                }
                if (prev == null || Count.this.separate(prev, this.t)) {
                    this.pos = Int32.ZERO;
                }
            }
            this.pos = this.pos.inc();
            return this.t.concat(this.pos);
        }

        @Override
        public void open(QueryContext ctx) {
            this.c.open(ctx);
            this.t = null;
            this.pos = Int32.ZERO;
        }
    }
}

