/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.operator;

import java.io.PrintStream;
import java.util.Arrays;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.operator.Cursor;
import org.brackit.xquery.operator.Operator;
import org.brackit.xquery.xdm.Sequence;

public class Print
implements Operator {
    private final Operator in;
    private final PrintStream out;

    public Print(Operator in, PrintStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) throws QueryException {
        return new PrintCursor(this.in.create(ctx, tuple), new Tuple[]{tuple}, this.out);
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) throws QueryException {
        return new PrintCursor(this.in.create(ctx, buf, len), buf, this.out);
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.in.tupleWidth(initSize);
    }

    public String asString(QueryContext ctx, Sequence sequence) throws QueryException {
        return sequence.toString();
    }

    protected class PrintCursor
    implements Cursor {
        private final Cursor c;
        private final Tuple[] t;
        private final PrintStream out;
        private int maxSize = 20;
        private int count;

        public PrintCursor(Cursor c, Tuple[] t, PrintStream out) {
            this.c = c;
            this.t = t;
            this.out = out;
        }

        @Override
        public void close(QueryContext ctx) {
            this.c.close(ctx);
            this.out.println("---");
            this.out.print(this.count);
            this.out.println(" results");
            this.out.flush();
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            Tuple next = this.c.next(ctx);
            if (next != null) {
                ++this.count;
                int size = next.getSize();
                this.out.print("|");
                for (int i = 0; i < size; ++i) {
                    this.out.print(' ');
                    Sequence sequence = next.get(i);
                    String s = sequence != null ? Print.this.asString(ctx, sequence) : "()";
                    s = this.shrinkOrPad(s);
                    this.out.print(s);
                    this.out.print(" |");
                }
                this.out.print('\n');
            }
            return next;
        }

        private String shrinkOrPad(String s) {
            int length = s.length();
            if (length == this.maxSize) {
                return s;
            }
            if (length > this.maxSize) {
                return s.substring(0, this.maxSize);
            }
            int toAdd = this.maxSize - length;
            char[] result = new char[this.maxSize];
            int i = 0;
            while (i < toAdd / 2) {
                result[i++] = 32;
            }
            System.arraycopy(s.toCharArray(), 0, result, i, length);
            int j = i + length;
            while (i++ < toAdd) {
                result[j++] = 32;
            }
            return new String(result);
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            this.c.open(ctx);
            this.count = 0;
            this.out.print("--- ");
            this.out.println(Arrays.toString(this.t));
        }
    }
}

