/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.operator;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.operator.Check;
import org.brackit.xquery.operator.Cursor;
import org.brackit.xquery.operator.Operator;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Sequence;

public class Select
extends Check
implements Operator {
    private final Operator in;
    final Expr predicate;

    public Select(Operator in, Expr predicate) {
        this.in = in;
        this.predicate = predicate;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) {
        return new SelectCursor(this.in.create(ctx, tuple));
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) {
        return new SelectCursor(this.in.create(ctx, buf, len));
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.in.tupleWidth(initSize);
    }

    public class SelectCursor
    implements Cursor {
        private final Cursor c;
        private Tuple prev;
        private Tuple next;

        public SelectCursor(Cursor c) {
            this.c = c;
        }

        @Override
        public void close(QueryContext ctx) {
            this.c.close(ctx);
        }

        @Override
        public Tuple next(QueryContext ctx) {
            Tuple t;
            while ((t = this.next) != null || (t = this.c.next(ctx)) != null) {
                Sequence p;
                this.next = null;
                if (Select.this.check && Select.this.dead(t) || (p = Select.this.predicate.evaluate(ctx, t)) != null && p.booleanValue()) break;
                if (!Select.this.check || this.prev != null && !Select.this.separate(this.prev, t)) continue;
                this.next = this.c.next(ctx);
                if (this.next != null && !Select.this.separate(t, this.next)) continue;
                t = t.replace(Select.this.local(), null);
                break;
            }
            this.prev = t;
            return t;
        }

        @Override
        public void open(QueryContext ctx) {
            this.c.open(ctx);
        }
    }
}

