/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.operator;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.operator.Cursor;
import org.brackit.xquery.operator.Operator;

public class Start
implements Operator {
    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) throws QueryException {
        return new StartCursor(tuple);
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) throws QueryException {
        return new BufferStartCursor(buf, len);
    }

    @Override
    public int tupleWidth(int initSize) {
        return initSize;
    }

    public static class StartCursor
    implements Cursor {
        final Tuple start;
        boolean open = false;
        boolean deliver = false;

        public StartCursor(Tuple start) {
            this.start = start;
        }

        @Override
        public void close(QueryContext ctx) {
            this.open = false;
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            if (!this.open) {
                throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR);
            }
            if (!this.deliver) {
                return null;
            }
            this.deliver = false;
            return this.start;
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            this.open = true;
            this.deliver = true;
        }
    }

    public static class BufferStartCursor
    implements Cursor {
        Tuple[] buf;
        final int len;
        int pos = -1;

        public BufferStartCursor(Tuple[] buf, int len) {
            this.buf = buf;
            this.len = len;
        }

        @Override
        public void close(QueryContext ctx) {
            this.buf = null;
            this.pos = -1;
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            if (this.pos < 0) {
                throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR);
            }
            if (this.pos < this.len) {
                Tuple t = this.buf[this.pos];
                this.buf[this.pos++] = null;
                return t;
            }
            return null;
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            this.pos = 0;
        }
    }
}

