/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.operator;

import java.util.Arrays;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.compiler.translator.Reference;
import org.brackit.xquery.operator.Check;
import org.brackit.xquery.operator.Cursor;
import org.brackit.xquery.operator.Operator;
import org.brackit.xquery.util.Cmp;
import org.brackit.xquery.util.join.FastList;
import org.brackit.xquery.util.join.MultiTypeJoinTable;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Sequence;

public class TableJoin
extends Check
implements Operator {
    final Operator l;
    final Operator r;
    final Expr rExpr;
    final Expr lExpr;
    final boolean leftJoin;
    final Cmp cmp;
    final boolean isGCmp;
    final boolean skipSort;
    int groupVar = -1;

    public TableJoin(Cmp cmp, boolean isGCmsp, boolean leftJoin, boolean skipSort, Operator l, Expr lExpr, Operator r, Expr rExpr) {
        this.cmp = cmp;
        this.isGCmp = isGCmsp;
        this.leftJoin = leftJoin;
        this.skipSort = skipSort;
        this.l = l;
        this.r = r;
        this.rExpr = rExpr;
        this.lExpr = lExpr;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) throws QueryException {
        int lSize = this.l.tupleWidth(tuple.getSize());
        int pad = this.r.tupleWidth(tuple.getSize()) - tuple.getSize();
        return new TableJoinCursor(this.l.create(ctx, tuple), lSize, pad);
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) throws QueryException {
        int lSize = this.l.tupleWidth(buf[0].getSize());
        int pad = this.r.tupleWidth(buf[0].getSize()) - buf[0].getSize();
        return new TableJoinCursor(this.l.create(ctx, buf, len), lSize, pad);
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.l.tupleWidth(initSize) + this.r.tupleWidth(initSize) - initSize;
    }

    public Reference group() {
        return new Reference(){

            @Override
            public void setPos(int pos) {
                TableJoin.this.groupVar = pos;
            }
        };
    }

    private class TableJoinCursor
    implements Cursor {
        final Cursor lc;
        final Sequence[] padding;
        final int lSize;
        private Tuple prev;
        private Tuple next;
        MultiTypeJoinTable table;
        Atomic tgk;
        Tuple tuple;
        FastList<Sequence[]> it;
        int itPos = 0;
        int itSize = 0;

        public TableJoinCursor(Cursor lc, int lSize, int pad) {
            this.lc = lc;
            this.lSize = lSize;
            this.padding = new Sequence[pad];
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            this.lc.open(ctx);
            this.it = null;
        }

        @Override
        public void close(QueryContext ctx) {
            this.lc.close(ctx);
            this.it = null;
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            if (this.it != null && this.itPos < this.itSize) {
                return this.tuple.concat(this.it.get(this.itPos++));
            }
            while ((this.tuple = this.next) != null || (this.tuple = this.lc.next(ctx)) != null) {
                this.next = null;
                if (TableJoin.this.check && TableJoin.this.dead(this.tuple)) {
                    this.prev = this.tuple.concat(this.padding);
                    return this.prev;
                }
                if (TableJoin.this.groupVar >= 0) {
                    Atomic gk = (Atomic)this.tuple.get(TableJoin.this.groupVar);
                    if (this.tgk != null && this.tgk.atomicCmp(gk) != 0) {
                        this.table = null;
                    }
                }
                if (this.table == null) {
                    this.buildTable(ctx, this.tuple);
                }
                Sequence keys = TableJoin.this.isGCmp ? TableJoin.this.lExpr.evaluate(ctx, this.tuple) : TableJoin.this.lExpr.evaluateToItem(ctx, this.tuple);
                FastList<Sequence[]> matches = this.table.probe(keys);
                this.it = matches;
                this.itPos = 0;
                this.itSize = matches.getSize();
                if (this.itPos < this.itSize) {
                    this.prev = this.tuple.concat(matches.get(this.itPos++));
                    return this.prev;
                }
                if (!TableJoin.this.leftJoin) continue;
                if (TableJoin.this.check) {
                    if (this.prev != null && !TableJoin.this.separate(this.prev, this.tuple)) continue;
                    this.next = this.lc.next(ctx);
                    if (this.next != null && !TableJoin.this.separate(this.tuple, this.next)) continue;
                    this.prev = this.tuple.conreplace(this.padding, TableJoin.this.local(), null);
                } else {
                    this.prev = this.tuple.concat(this.padding);
                }
                return this.prev;
            }
            this.table = null;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void buildTable(QueryContext ctx, Tuple tuple) throws QueryException {
            this.table = new MultiTypeJoinTable(TableJoin.this.cmp, TableJoin.this.isGCmp, TableJoin.this.skipSort);
            if (TableJoin.this.groupVar >= 0) {
                this.tgk = (Atomic)tuple.get(TableJoin.this.groupVar);
            }
            int pos = 1;
            Cursor rc = TableJoin.this.r.create(ctx, tuple);
            try {
                Tuple t;
                rc.open(ctx);
                while ((t = rc.next(ctx)) != null) {
                    Sequence keys = TableJoin.this.isGCmp ? TableJoin.this.rExpr.evaluate(ctx, t) : TableJoin.this.rExpr.evaluateToItem(ctx, t);
                    if (keys == null) continue;
                    Sequence[] tmp = t.array();
                    Sequence[] bindings = Arrays.copyOfRange(tmp, this.lSize, tmp.length);
                    this.table.add(keys, bindings, pos++);
                }
            }
            finally {
                rc.close(ctx);
            }
        }
    }
}

