/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.sequence;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.operator.TupleImpl;
import org.brackit.xquery.util.ExprUtil;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;

public abstract class AbstractSequence
implements Sequence {
    @Override
    public final Sequence evaluate(QueryContext ctx, Tuple context) {
        return this;
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return ExprUtil.asItem(this);
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    @Override
    public Sequence[] array() {
        return new Sequence[]{this};
    }

    @Override
    public Sequence get(int position) {
        if (position != 0) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, position);
        }
        return this;
    }

    @Override
    public Tuple project(int ... positions) {
        Sequence[] projected = new Sequence[positions.length];
        int targetPos = 0;
        for (int pos : positions) {
            projected[targetPos++] = this.get(pos);
        }
        return new TupleImpl(projected);
    }

    @Override
    public Tuple project(int start, int end) {
        if (start != 0) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, start);
        }
        if (end != 0) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, end);
        }
        return this;
    }

    @Override
    public Tuple replace(int position, Sequence s) {
        if (position != 0) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, position);
        }
        return new TupleImpl(s);
    }

    @Override
    public Tuple concat(Sequence s) {
        return new TupleImpl(new Sequence[]{this, s});
    }

    @Override
    public Tuple concat(Sequence[] s) {
        Sequence[] tmp = new Sequence[s.length + 1];
        tmp[0] = this;
        System.arraycopy(s, 0, tmp, 1, s.length);
        return new TupleImpl(tmp);
    }

    @Override
    public Tuple conreplace(Sequence con, int position, Sequence s) {
        if (position < 0 || position >= 2) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, position);
        }
        Sequence[] tmp = new Sequence[]{this, con};
        tmp[position] = s;
        return new TupleImpl(tmp);
    }

    @Override
    public Tuple conreplace(Sequence[] con, int position, Sequence s) {
        int nLen = con.length + 1;
        if (position < 0 || position >= nLen) {
            throw new QueryException(ErrorCode.BIT_DYN_RT_OUT_OF_BOUNDS_ERROR, position);
        }
        Sequence[] tmp = new Sequence[nLen];
        tmp[0] = this;
        System.arraycopy(con, 0, tmp, 1, con.length);
        tmp[position] = s;
        return new TupleImpl(tmp);
    }

    @Override
    public int getSize() {
        return 1;
    }
}

