/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.sequence;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.sequence.AbstractSequence;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.node.Node;

public class ItemSequence
extends AbstractSequence {
    protected final Item[] items;

    public ItemSequence(Item ... items) {
        this.items = items;
    }

    @Override
    public boolean booleanValue() {
        if (this.items.length == 0) {
            return false;
        }
        if (this.items[0] instanceof Node) {
            return true;
        }
        if (this.items.length > 1) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value is undefined for sequences with two or more items not starting with a node");
        }
        return this.items[0].booleanValue();
    }

    @Override
    public IntNumeric size() {
        return new Int32(this.items.length);
    }

    @Override
    public Item get(IntNumeric pos) {
        if (Int32.ZERO.cmp(pos) >= 0 || this.size().cmp(pos) < 0) {
            return null;
        }
        return this.items[pos.intValue() - 1];
    }

    @Override
    public Iter iterate() {
        return new BaseIter(){
            int pos = 0;

            @Override
            public Item next() {
                return this.pos < ItemSequence.this.items.length ? ItemSequence.this.items[this.pos++] : null;
            }

            @Override
            public void close() {
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.items.length > 0) {
            sb.append(this.items[0]);
            for (int i = 1; i < this.items.length; ++i) {
                sb.append(",");
                sb.append(this.items[i]);
            }
        }
        return sb.toString();
    }
}

