/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.sequence;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Counter;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.sequence.AbstractSequence;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.node.Node;

public abstract class LazySequence
extends AbstractSequence {
    private volatile IntNumeric size;
    private volatile Boolean bool;

    @Override
    public final boolean booleanValue() {
        Boolean b = this.bool;
        if (b != null) {
            return b;
        }
        try (Iter s = this.iterate();){
            Item n = s.next();
            if (n == null) {
                this.bool = false;
                boolean bl = this.bool;
                return bl;
            }
            if (n instanceof Node) {
                this.bool = true;
                boolean bl = this.bool;
                return bl;
            }
            if (s.next() != null) {
                throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value is undefined for sequences with two or more items not starting with a node");
            }
            this.bool = n.booleanValue();
            boolean bl = this.bool;
            return bl;
        }
    }

    @Override
    public final IntNumeric size() {
        IntNumeric si = this.size;
        if (si != null) {
            return si;
        }
        Counter count = new Counter();
        try (Iter s = this.iterate();){
            while (s.next() != null) {
                count.inc();
            }
        }
        this.size = count.asIntNumeric();
        return this.size;
    }

    @Override
    public Item get(IntNumeric pos) {
        IntNumeric si = this.size;
        if (si != null && si.cmp(pos) < 0) {
            return null;
        }
        if (Int32.ZERO.cmp(pos) >= 0) {
            return null;
        }
        Counter count = new Counter();
        try (Iter it = this.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                if (count.inc().cmp(pos) != 0) continue;
                Item item2 = item;
                return item2;
            }
        }
        if (si == null) {
            this.size = count.asIntNumeric();
        }
        return null;
    }
}

