/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.sequence;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Counter;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.LazySequence;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.ItemType;
import org.brackit.xquery.xdm.type.SequenceType;

public class TypedSequence
extends LazySequence {
    private static final Int32 TWO = Int32.ZERO_TWO_TWENTY[2];
    final SequenceType type;
    final Sequence arg;
    volatile boolean safe;

    public TypedSequence(SequenceType type, Sequence arg) {
        this.type = type;
        this.arg = arg;
    }

    @Override
    public Iter iterate() {
        if (this.safe) {
            return this.arg.iterate();
        }
        return new TypedIter();
    }

    @Override
    public Item get(IntNumeric pos) {
        Item item = this.arg.get(pos);
        if (this.safe) {
            return item;
        }
        Cardinality card = this.type.getCardinality();
        if (item == null) {
            if (card.moreThanZero()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid empty typed sequence (expected %s)", new Object[]{card});
            }
        } else {
            if (pos.cmp(Int32.ONE) > 0 && card.atMostOne()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid cardinality of typed sequence (expected %s): >= %s", new Object[]{card, pos});
            }
            if (pos.cmp(Int32.ZERO) > 0 && card == Cardinality.Zero) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid cardinality of typed sequence (expected %s): >= %s", new Object[]{card, pos});
            }
            if (!this.type.getItemType().matches(item)) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid type in typed sequence (expected %s): %s", this.type.getItemType(), item);
            }
        }
        return item;
    }

    public static Sequence toTypedSequence(SequenceType sType, Sequence s) {
        if (s == null) {
            if (sType.getCardinality().moreThanZero()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid empty-sequence()");
            }
            return null;
        }
        if (s instanceof Item) {
            ItemType itemType = sType.getItemType();
            if (!itemType.matches((Item)s)) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid type %s in typed sequence (expected %s): %s", ((Item)s).itemType(), itemType, s);
            }
            return s;
        }
        return new TypedSequence(sType, s);
    }

    public static Item toTypedItem(SequenceType sType, Item item) {
        if (item == null) {
            if (sType.getCardinality().moreThanZero()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid empty-sequence()");
            }
            return null;
        }
        ItemType itemType = sType.getItemType();
        if (!itemType.matches(item)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid type %s in typed sequence (expected %s): %s", item.itemType(), itemType, item);
        }
        return item;
    }

    public static Item toTypedItem(SequenceType sType, Sequence s) {
        if (s == null) {
            if (sType.getCardinality().moreThanZero()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid empty-sequence()");
            }
            return null;
        }
        if (s instanceof Item) {
            Item item;
            ItemType itemType = sType.getItemType();
            if (!itemType.matches(item = (Item)s)) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid type %s in typed sequence (expected %s): %s", item.itemType(), itemType, item);
            }
            return item;
        }
        try (Iter it = s.iterate();){
            Item item = it.next();
            if (it.next() != null) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot convert %s typed sequence %s to single item", sType, s);
            }
            Item item2 = TypedSequence.toTypedItem(sType, item);
            return item2;
        }
    }

    private final class TypedIter
    extends BaseIter {
        Cardinality card;
        ItemType iType;
        Counter pos;
        Iter s;

        private TypedIter() {
            this.card = TypedSequence.this.type.getCardinality();
            this.iType = TypedSequence.this.type.getItemType();
            this.pos = new Counter();
        }

        @Override
        public Item next() {
            Item item;
            if (this.s == null) {
                this.s = TypedSequence.this.arg.iterate();
            }
            if ((item = this.s.next()) == null) {
                if (this.pos.cmp(Int32.ZERO) == 0 && this.card.moreThanZero()) {
                    throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid empty typed sequence (expected %s)", new Object[]{this.card});
                }
                TypedSequence.this.safe = true;
                return null;
            }
            this.pos.inc();
            if (this.card == Cardinality.Zero || this.pos.cmp(TWO) == 0 && this.card.atMostOne()) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Invalid cardinality of typed sequence (expected %s): >= %s", new Object[]{this.card, this.pos});
            }
            if (!this.iType.matches(item)) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Item of invalid type in typed sequence (expected %s): %s", this.iType, item);
            }
            return item;
        }

        @Override
        public void skip(IntNumeric i) {
            if (this.s == null) {
                this.s = TypedSequence.this.arg.iterate();
            }
            this.s.skip(i);
        }

        @Override
        public void close() {
            if (this.s != null) {
                this.s.close();
            }
        }
    }
}

