/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.update;

import java.util.EnumSet;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.expr.ConstructedNodeBuilder;
import org.brackit.xquery.update.op.AbstractInsertOp;
import org.brackit.xquery.update.op.InsertAfterOp;
import org.brackit.xquery.update.op.InsertAttributesOp;
import org.brackit.xquery.update.op.InsertBeforeOp;
import org.brackit.xquery.update.op.InsertIntoAsFirstOp;
import org.brackit.xquery.update.op.InsertIntoAsLastOp;
import org.brackit.xquery.update.op.InsertIntoOp;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;

public final class Insert
extends ConstructedNodeBuilder
implements Expr {
    private static final EnumSet<Kind> abNodeKind = EnumSet.of(Kind.ELEMENT, Kind.TEXT, Kind.COMMENT, Kind.PROCESSING_INSTRUCTION);
    private static final EnumSet<Kind> intoNodeKind = EnumSet.of(Kind.DOCUMENT, Kind.ELEMENT);
    private final Expr sourceExpr;
    private final Expr targetExpr;
    private final InsertType insertType;

    public Insert(Expr sourceExpr, Expr targetExpr, InsertType insertType) {
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
        this.insertType = insertType;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        if (this.insertType == InsertType.AFTER || this.insertType == InsertType.BEFORE) {
            this.insertAB(ctx, tuple);
        } else {
            this.insertInto(ctx, tuple);
        }
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    private void insertInto(QueryContext ctx, Tuple tuple) {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_NOT_A_SINGLE_ED_NODE);
                }
            }
        }
        if (!(targetItem instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_NOT_A_SINGLE_ED_NODE, "Target item is atomic value %s", targetItem);
        }
        Node node = (Node)targetItem;
        if (!intoNodeKind.contains((Object)node.getKind())) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_NOT_A_SINGLE_ED_NODE, "Target node kind %s is not allowed for insert type: %s", new Object[]{node.getKind(), this.insertType});
        }
        AbstractInsertOp opOp = null;
        AbstractInsertOp insertAttsOp = null;
        Sequence source = this.sourceExpr.evaluate(ctx, tuple);
        ConstructedNodeBuilder.ContentList cList = new ConstructedNodeBuilder.ContentList();
        this.buildContentSequence(ctx, cList, source);
        for (Node insertNode : cList) {
            if (insertNode.getKind() == Kind.ATTRIBUTE) {
                if (insertAttsOp == null) {
                    if (node.getKind() != Kind.ELEMENT) {
                        throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_INTO_TARGET_IS_DOCUMENT_NODE);
                    }
                    insertAttsOp = new InsertAttributesOp(node);
                }
                insertAttsOp.addContent(insertNode);
                continue;
            }
            if (opOp == null) {
                opOp = this.createOpOp(node);
            }
            opOp.addContent(insertNode);
        }
        if (insertAttsOp != null) {
            ctx.addPendingUpdate(insertAttsOp);
        }
        if (opOp != null) {
            ctx.addPendingUpdate(opOp);
        }
    }

    private void insertAB(QueryContext ctx, Tuple tuple) {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_NOT_A_SINGLE_ETCP_NODE);
                }
            }
        }
        if (!(targetItem instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_NOT_A_SINGLE_ETCP_NODE, "Target item is atomic value %s", targetItem);
        }
        Node node = (Node)targetItem;
        if (!abNodeKind.contains((Object)node.getKind())) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_NOT_A_SINGLE_ETCP_NODE, "Target node kind %s is not allowed for insert type: %", new Object[]{node.getKind(), this.insertType});
        }
        Object parent = node.getParent();
        if (parent == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_NODE_HAS_NO_PARENT);
        }
        AbstractInsertOp opOp = null;
        AbstractInsertOp insertAttsOp = null;
        Sequence source = this.sourceExpr.evaluate(ctx, tuple);
        ConstructedNodeBuilder.ContentList cList = new ConstructedNodeBuilder.ContentList();
        this.buildContentSequence(ctx, cList, source);
        for (Node insertNode : cList) {
            if (insertNode.getKind() == Kind.ATTRIBUTE) {
                if (insertAttsOp == null) {
                    if (parent.getKind() != Kind.ELEMENT) {
                        throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_BEFORE_AFTER_TARGET_PARENT_IS_DOCUMENT_NODE);
                    }
                    insertAttsOp = new InsertAttributesOp((Node<?>)parent);
                }
                insertAttsOp.addContent(insertNode);
                continue;
            }
            if (opOp == null) {
                opOp = this.createOpOp(node);
            }
            opOp.addContent(insertNode);
        }
        if (insertAttsOp != null) {
            ctx.addPendingUpdate(insertAttsOp);
        }
        if (opOp != null) {
            ctx.addPendingUpdate(opOp);
        }
    }

    private AbstractInsertOp createOpOp(Node<?> node) {
        return switch (this.insertType) {
            case InsertType.AFTER -> new InsertAfterOp(node);
            case InsertType.BEFORE -> new InsertBeforeOp(node);
            case InsertType.FIRST -> new InsertIntoAsFirstOp(node);
            case InsertType.LAST -> new InsertIntoAsLastOp(node);
            case InsertType.INTO -> new InsertIntoOp(node);
            default -> throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR);
        };
    }

    public static enum InsertType {
        FIRST,
        LAST,
        INTO,
        BEFORE,
        AFTER;

    }
}

