/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.update;

import java.util.EnumSet;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.expr.ConstructedNodeBuilder;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.update.op.RenameOp;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;

public class Rename
extends ConstructedNodeBuilder
implements Expr {
    private static final EnumSet<Kind> renameNodeKind = EnumSet.of(Kind.ELEMENT, Kind.ATTRIBUTE, Kind.PROCESSING_INSTRUCTION);
    private final StaticContext sctx;
    private final Expr sourceExpr;
    private final Expr targetExpr;

    public Rename(StaticContext sctx, Expr sourceExpr, Expr targetExpr) {
        this.sctx = sctx;
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_RENAME_TARGET_NOT_A_EAP_NODE);
                }
            }
        }
        if (!(targetItem instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_RENAME_TARGET_NOT_A_EAP_NODE, "Target item is atomic value %s", targetItem);
        }
        Node node = (Node)targetItem;
        if (!renameNodeKind.contains((Object)node.getKind())) {
            throw new QueryException(ErrorCode.ERR_UPDATE_RENAME_TARGET_NOT_A_EAP_NODE, "Target node kind is not allowed for rename node: %s", new Object[]{node.getKind()});
        }
        Item nameItem = this.sourceExpr.evaluateToItem(ctx, tuple);
        QNm name = node.getKind() == Kind.ELEMENT ? this.buildElementName(this.sctx, nameItem) : (node.getKind() == Kind.ATTRIBUTE ? this.buildAttributeName(this.sctx, nameItem) : this.buildPITarget(nameItem));
        ctx.addPendingUpdate(new RenameOp(node, name));
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

