/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.update;

import java.util.EnumSet;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.expr.ConstructedNodeBuilder;
import org.brackit.xquery.update.op.ReplaceNodeOp;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;

public class ReplaceNode
extends ConstructedNodeBuilder
implements Expr {
    private static final EnumSet<Kind> replaceNodeKind = EnumSet.of(Kind.ELEMENT, Kind.ATTRIBUTE, Kind.TEXT, Kind.COMMENT, Kind.PROCESSING_INSTRUCTION);
    private static final EnumSet<Kind> allowedForReplaceNonAtt = EnumSet.of(Kind.ELEMENT, Kind.TEXT, Kind.COMMENT, Kind.PROCESSING_INSTRUCTION);
    private final Expr sourceExpr;
    private final Expr targetExpr;

    public ReplaceNode(Expr sourceExpr, Expr targetExpr) {
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE);
                }
            }
        }
        if (!(targetItem instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE, "Target item is atomic value %s", targetItem);
        }
        Node node = (Node)targetItem;
        if (!allowedForReplaceNonAtt.contains((Object)node.getKind())) {
            throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE, "Target node kind %s is not allowed for replace node: %s", new Object[]{node.getKind(), node});
        }
        Object parent = node.getParent();
        if (parent == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NODE_HAS_NO_PARENT);
        }
        Sequence source = this.sourceExpr.evaluate(ctx, tuple);
        ConstructedNodeBuilder.ContentList rList = new ConstructedNodeBuilder.ContentList();
        this.buildContentSequence(ctx, rList, source);
        ReplaceNodeOp op = null;
        if (node.getKind() != Kind.ATTRIBUTE) {
            for (Node replacement : rList) {
                if (!allowedForReplaceNonAtt.contains((Object)replacement.getKind())) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_NODE_REPLACEMENT_NOT_A_ETCP_NODE, "Cannot replace node of type %s with node of type %s", new Object[]{node.getKind(), replacement.getKind()});
                }
                if (op == null) {
                    op = new ReplaceNodeOp(node);
                }
                op.addContent(replacement);
            }
        } else {
            for (Node replacement : rList) {
                if (replacement.getKind() != Kind.ATTRIBUTE) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_NODE_REPLACEMENT_NOT_AN_A_NODE, "Cannot replace attribute with node of type %s", new Object[]{replacement.getKind()});
                }
                if (op == null) {
                    op = new ReplaceNodeOp(node);
                }
                op.addContent(replacement);
            }
        }
        if (op != null) {
            ctx.addPendingUpdate(op);
        }
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

