/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.update;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.update.op.OpType;
import org.brackit.xquery.update.op.UpdateOp;
import org.brackit.xquery.util.log.Logger;

public final class UpdateList {
    private static final Logger log = Logger.getLogger(UpdateList.class);
    private static final EnumSet<OpType> checkOps = EnumSet.of(OpType.RENAME, OpType.REPLACE_NODE, OpType.REPLACE_VALUE, OpType.REPLACE_ELEMENT_CONTENT);
    private final List<UpdateOp> ops = new ArrayList<UpdateOp>();

    public void append(UpdateOp op) {
        this.ops.add(op);
    }

    public void apply() throws QueryException {
        Comparator<UpdateOp> orderByTypeCmp = Comparator.comparing(UpdateOp::getType);
        this.ops.sort(orderByTypeCmp);
        int size = this.ops.size();
        for (int i = 0; i < size; ++i) {
            UpdateOp secondOperator;
            UpdateOp firstOperator = this.ops.get(i);
            if (!checkOps.contains((Object)firstOperator.getType())) continue;
            for (int j = i + 1; j < this.ops.size() && (secondOperator = this.ops.get(j)).getType() == firstOperator.getType(); ++j) {
                this.checkCompatibility(firstOperator, secondOperator);
            }
        }
        this.ops.forEach(op -> {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Applying pending update %s", op));
            }
            op.apply();
        });
    }

    private void checkCompatibility(UpdateOp op1, UpdateOp op2) throws QueryException {
        switch (op1.getType()) {
            case RENAME: {
                if (!op1.getTarget().equals(op2.getTarget())) break;
                throw new QueryException(ErrorCode.ERR_UPDATE_DUPLICATE_RENAME_TARGET, "Node %s is target of more than one replace operation.", op2.getTarget());
            }
            case REPLACE_NODE: {
                if (op1.getTarget().itemType().isRecord() && op2.getTarget().itemType().isRecord()) {
                    return;
                }
                if (op1.getTarget().itemType().isListOrUnion() && op2.getTarget().itemType().isListOrUnion()) {
                    return;
                }
                if (!op1.getTarget().equals(op2.getTarget())) break;
                throw new QueryException(ErrorCode.ERR_UPDATE_DUPLICATE_REPLACE_NODE_TARGET, "Node %s is target of more than one replace node operation.", op2.getTarget());
            }
            case REPLACE_VALUE: {
                if (op1.getTarget().itemType().isRecord() && op2.getTarget().itemType().isRecord()) {
                    return;
                }
                if (op1.getTarget().itemType().isListOrUnion() && op2.getTarget().itemType().isListOrUnion()) {
                    return;
                }
                if (!op1.getTarget().equals(op2.getTarget())) break;
                throw new QueryException(ErrorCode.ERR_UPDATE_DUPLICATE_REPLACE_VALUE_TARGET, "Node %s is target of more than one replace value operation.", op2.getTarget());
            }
            case REPLACE_ELEMENT_CONTENT: {
                if (!op1.getTarget().equals(op2.getTarget())) break;
                throw new QueryException(ErrorCode.ERR_UPDATE_DUPLICATE_REPLACE_VALUE_TARGET, "Node %s is target of more than one replace element content operation.", op2.getTarget());
            }
        }
    }

    public List<UpdateOp> list() {
        return this.ops;
    }
}

