/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.update.json;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.update.json.op.DeleteArrayIndexOp;
import org.brackit.xquery.update.json.op.DeleteRecordFieldOp;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.Array;
import org.brackit.xquery.xdm.json.JsonItem;
import org.brackit.xquery.xdm.json.Record;

public final class DeleteJson
implements Expr {
    private final Expr expr;
    private final Expr fieldOrIndex;

    public DeleteJson(Expr expr, Expr fieldOrIndex) {
        this.expr = expr;
        this.fieldOrIndex = fieldOrIndex;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence result = this.expr.evaluate(ctx, tuple);
        if (result == null) {
            return null;
        }
        if (result instanceof Item) {
            this.handleItem(ctx, (Item)result, tuple);
            return null;
        }
        try (Iter it = result.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                this.handleItem(ctx, item, tuple);
            }
        }
        return null;
    }

    private void handleItem(QueryContext ctx, Item item, Tuple tuple) {
        if (!(item instanceof JsonItem)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_DELETE_TARGET_NOT_A_NODE_SEQUENCE, "Target item for delete is not a json item: %s", item);
        }
        if (item instanceof Array) {
            ctx.addPendingUpdate(new DeleteArrayIndexOp((Array)item, ((Int32)this.fieldOrIndex.evaluateToItem(ctx, tuple)).intValue()));
        } else {
            Item evaluatedItem = this.fieldOrIndex.evaluateToItem(ctx, tuple);
            if (evaluatedItem instanceof QNm) {
                QNm qNm = (QNm)evaluatedItem;
                ctx.addPendingUpdate(new DeleteRecordFieldOp((Record)item, qNm));
            } else if (evaluatedItem instanceof Str) {
                ctx.addPendingUpdate(new DeleteRecordFieldOp((Record)item, new QNm(evaluatedItem.toString())));
            }
        }
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

