/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.update.json;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.expr.ConstructedNodeBuilder;
import org.brackit.xquery.update.json.op.RenameRecordFieldOp;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.Record;

public final class RenameJsonField
extends ConstructedNodeBuilder
implements Expr {
    private final Expr oldFieldNameExpr;
    private final Expr targetExpr;
    private final Expr newFieldNameExpr;

    public RenameJsonField(Expr targetExpr, Expr oldFieldNameExpr, Expr newFieldNameExpr) {
        this.targetExpr = targetExpr;
        this.oldFieldNameExpr = oldFieldNameExpr;
        this.newFieldNameExpr = newFieldNameExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE);
                }
            }
        }
        if (!(targetItem instanceof Record)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE, "Target item is atomic value %s", targetItem);
        }
        QNm oldFieldName = (QNm)this.oldFieldNameExpr.evaluateToItem(ctx, tuple);
        QNm newFieldName = new QNm(((Str)this.newFieldNameExpr.evaluateToItem(ctx, tuple)).stringValue());
        ctx.addPendingUpdate(new RenameRecordFieldOp((Record)target, oldFieldName, newFieldName));
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

