/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.update.json;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.expr.ConstructedNodeBuilder;
import org.brackit.xquery.update.json.op.ReplaceArrayValueOp;
import org.brackit.xquery.update.json.op.ReplaceRecordValueOp;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.Array;
import org.brackit.xquery.xdm.json.JsonItem;
import org.brackit.xquery.xdm.json.Record;

public final class ReplaceJsonValue
extends ConstructedNodeBuilder
implements Expr {
    private final Expr sourceExpr;
    private final Expr targetExpr;
    private final Expr recordFieldOrArrayIndex;

    public ReplaceJsonValue(Expr sourceExpr, Expr targetExpr, Expr recordFieldOrArrayIndex) {
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
        this.recordFieldOrArrayIndex = recordFieldOrArrayIndex;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE);
                }
            }
        }
        if (!(targetItem instanceof JsonItem)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE, "Target item is atomic value %s", targetItem);
        }
        Item recordFieldOrArrayIndexSeq = this.recordFieldOrArrayIndex.evaluateToItem(ctx, tuple);
        Item source = this.sourceExpr.evaluateToItem(ctx, tuple);
        if (target instanceof Array) {
            Int32 index = (Int32)recordFieldOrArrayIndexSeq;
            ctx.addPendingUpdate(new ReplaceArrayValueOp((Array)target, index.intValue(), source));
        } else {
            QNm field = (QNm)recordFieldOrArrayIndexSeq;
            ctx.addPendingUpdate(new ReplaceRecordValueOp((Record)target, field, source));
        }
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

