/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Bool;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.sequence.ItemSequence;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;

public class Regex {
    private static final List<Character> WHITESPACE = Arrays.asList(Character.valueOf(Character.toChars(9)[0]), Character.valueOf(Character.toChars(10)[0]), Character.valueOf(Character.toChars(13)[0]), Character.valueOf(Character.toChars(32)[0]));

    public static Sequence match(Mode mode, String input, String pattern, String replace, String flags) throws QueryException {
        Pattern cpattern;
        boolean removeWhitespace = false;
        int flagMask = 1;
        if (flags != null) {
            if (flags.contains("x")) {
                removeWhitespace = true;
                flags = flags.replace("x", "");
            }
            if (flags.contains("s")) {
                flagMask |= 0x20;
                flags = flags.replace("s", "");
            }
            if (flags.contains("m")) {
                flagMask |= 8;
                flags = flags.replace("m", "");
            }
            if (flags.contains("i")) {
                flagMask |= 0x42;
                flags = flags.replace("i", "");
            }
            if (!flags.isEmpty()) {
                throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION_FLAGS, "Unknown flags specified.");
            }
        }
        if (mode != Mode.MATCH && Pattern.matches(pattern, "")) {
            throw new QueryException(ErrorCode.ERR_REGULAR_EXPRESSION_EMPTY_STRING, "Pattern matches empty string.");
        }
        if (mode == Mode.TOKENIZE && input.isEmpty()) {
            return null;
        }
        try {
            String regex = Regex.adaptRegEx(mode, pattern, flagMask, removeWhitespace);
            cpattern = Pattern.compile(regex, flagMask);
        }
        catch (PatternSyntaxException e) {
            throw new QueryException(e, ErrorCode.ERR_INVALID_REGULAR_EXPRESSION);
        }
        Matcher matcher = cpattern.matcher(input);
        switch (mode) {
            case MATCH: {
                return new Bool(matcher.matches());
            }
            case REPLACE: {
                String pat = "(\\$|\\\\|.*[^\\\\]\\$\\D.*|.*[^\\\\]\\\\[^\\$].*)";
                if (Pattern.matches(pat, replace)) {
                    throw new QueryException(ErrorCode.ERR_INVALID_REPLACEMENT_STRING, "Replacement string matches makes illegal use of chars '\\' or '$'.");
                }
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, replace);
                }
                matcher.appendTail(sb);
                return new Str(sb.toString());
            }
            case TOKENIZE: {
                String[] tokens = cpattern.split(input, -1);
                Item[] items = new Str[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    items[i] = new Str(tokens[i]);
                }
                return new ItemSequence(items);
            }
        }
        return null;
    }

    private static String adaptRegEx(Mode mode, String regex, int flagMask, boolean removeWhitespace) throws QueryException {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        boolean groupStart = false;
        int completeGroups = 0;
        int backRef = 0;
        int charClassDepth = 0;
        int groupDepth = 0;
        for (char c : regex.toCharArray()) {
            if (escaped) {
                if (backRef == 0 && c == '0') {
                    throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION, "Reference to group 0 not allowed");
                }
                if (c >= '0' && c <= '9') {
                    if (charClassDepth > 0) {
                        throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION, "Back references in character class expressions are disallowed.");
                    }
                    backRef = backRef * 10 + Integer.parseInt(Character.toString(c));
                    continue;
                }
            }
            if (backRef > 0) {
                if (backRef > completeGroups) {
                    throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION, "Back reference to nonexisting or unfinished group.");
                }
                backRef = 0;
                escaped = false;
            }
            if (c == '\\' && !escaped) {
                escaped = true;
                groupStart = false;
                continue;
            }
            if (c == '(' && !escaped) {
                groupStart = true;
                ++groupDepth;
                escaped = false;
                continue;
            }
            if (c == '?' && !escaped && groupStart) {
                throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION, "Pure groups are not supported in XQuery regular expressions.");
            }
            if (c == ')' && !escaped) {
                if (--groupDepth < 0) {
                    throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION, "Invalid sequence of brackets.");
                }
                ++completeGroups;
            } else if (c == '[' && !escaped) {
                ++charClassDepth;
            } else if (c == ']' && !escaped) {
                if (--charClassDepth < 0) {
                    throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION, "Invalid sequence of brackets.");
                }
            } else if (removeWhitespace) {
                if (charClassDepth == 0 && WHITESPACE.contains(Character.valueOf(c))) continue;
                sb.append(c);
            }
            groupStart = false;
            escaped = false;
        }
        if (escaped && backRef == 0) {
            throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION, "Trailing backslash character in pattern.");
        }
        if (backRef > 0 && backRef > completeGroups) {
            throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION, "Back reference to nonexisting or unfinished group.");
        }
        if (charClassDepth != 0 || groupDepth != 0) {
            throw new QueryException(ErrorCode.ERR_INVALID_REGULAR_EXPRESSION, "Pattern contains dangling brackets.");
        }
        if (!removeWhitespace) {
            sb.append(regex);
        }
        if (mode == Mode.MATCH) {
            if (sb.charAt(0) != '^' || (flagMask & 8) == 8) {
                if ((flagMask & 0x20) == 32) {
                    sb.insert(0, ".*");
                } else {
                    sb.insert(0, "(?s:.*)");
                }
            }
            if (sb.charAt(sb.length() - 1) != '$' || (flagMask & 8) == 8) {
                if ((flagMask & 0x20) == 32) {
                    sb.append(".*");
                } else {
                    sb.append("(?s:.*)");
                }
            }
        }
        return sb.toString();
    }

    public static enum Mode {
        MATCH,
        REPLACE,
        TOKENIZE;

    }
}

