/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.aggregator;

import org.brackit.xquery.util.aggregator.Aggregator;
import org.brackit.xquery.util.aggregator.CountAggregator;
import org.brackit.xquery.util.aggregator.MinMaxAggregator;
import org.brackit.xquery.util.aggregator.SequenceAggregator;
import org.brackit.xquery.util.aggregator.SingleAggregator;
import org.brackit.xquery.util.aggregator.SumAvgAggregator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Aggregate {
    SEQUENCE{

        @Override
        public Aggregator aggregator() {
            return new SequenceAggregator();
        }
    }
    ,
    COUNT{

        @Override
        public Aggregator aggregator() {
            return new CountAggregator();
        }
    }
    ,
    SUM{

        @Override
        public Aggregator aggregator() {
            return new SumAvgAggregator(false, null);
        }
    }
    ,
    AVG{

        @Override
        public Aggregator aggregator() {
            return new SumAvgAggregator(true, null);
        }
    }
    ,
    MIN{

        @Override
        public Aggregator aggregator() {
            return new MinMaxAggregator(true);
        }
    }
    ,
    MAX{

        @Override
        public Aggregator aggregator() {
            return new MinMaxAggregator(false);
        }
    }
    ,
    SINGLE{

        @Override
        public Aggregator aggregator() {
            return new SingleAggregator();
        }
    };


    public abstract Aggregator aggregator();
}

