/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.aggregator;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Numeric;
import org.brackit.xquery.expr.Cast;
import org.brackit.xquery.util.aggregator.Aggregator;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Type;

public class MinMaxAggregator
implements Aggregator {
    final boolean min;
    AggType aggType;
    Atomic minmax = null;
    Type minmaxType = null;

    public MinMaxAggregator(boolean min) {
        this.min = min;
    }

    @Override
    public Sequence getAggregate() {
        return this.minmax;
    }

    @Override
    public void clear() {
        this.aggType = null;
        this.minmax = null;
        this.minmaxType = null;
    }

    @Override
    public void add(Sequence seq) throws QueryException {
        if (seq == null) {
            return;
        }
        if (seq instanceof Item) {
            this.addItem((Item)seq, this.minmax == null);
        } else {
            this.addSequence(seq, this.minmax == null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSequence(Sequence seq, boolean first) throws QueryException {
        try (Iter in = seq.iterate();){
            if (first) {
                Item item = in.next();
                if (item != null) {
                    this.addItem(item, first);
                } else {
                    return;
                }
            }
            if (this.aggType == AggType.NUMERIC) {
                this.minmax = this.numericMinmax(in, this.minmax);
            } else if (this.aggType == AggType.STRING) {
                this.minmax = this.stringMinmax(in, this.minmax);
            } else if (this.aggType == AggType.GENERIC) {
                this.minmax = this.genericMinmax(in, this.minmax);
            }
        }
    }

    private void addItem(Item item, boolean first) throws QueryException {
        if (!first) {
            if (this.aggType == AggType.NUMERIC) {
                this.minmax = this.numericMinmax(this.minmax, item, this.minmax.type().getPrimitiveBase());
            } else if (this.aggType == AggType.STRING) {
                this.minmax = this.stringMinmax(this.minmax, item, this.minmax.type().getPrimitiveBase());
            } else if (this.aggType == AggType.GENERIC) {
                this.minmax = this.genericMinmax(this.minmax, item, this.minmax.type().getPrimitiveBase());
            }
        } else {
            this.minmax = item.atomize();
            this.minmaxType = this.minmax.type();
            if (this.minmaxType == Type.UNA) {
                this.minmax = Cast.cast(null, this.minmax, Type.DBL, false);
                this.minmaxType = Type.DBL;
            }
            if (this.minmaxType.isNumeric()) {
                this.aggType = AggType.NUMERIC;
            } else if (this.minmaxType.instanceOf(Type.STR)) {
                this.aggType = AggType.STRING;
            } else if (this.minmaxType.instanceOf(Type.YMD) || this.minmaxType.instanceOf(Type.DTD) || this.minmaxType.instanceOf(Type.DATE) || this.minmaxType.instanceOf(Type.AURI) || this.minmaxType.instanceOf(Type.BOOL) || this.minmaxType.instanceOf(Type.DATE) || this.minmaxType.instanceOf(Type.TIME)) {
                this.aggType = AggType.GENERIC;
            } else {
                throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Cannot compute min/max for items of type: %s", this.minmaxType);
            }
        }
    }

    private Atomic genericMinmax(Iter in, Atomic minmax) throws QueryException {
        Item item;
        Type minmaxType = minmax.type().getPrimitiveBase();
        while ((item = in.next()) != null) {
            minmax = this.genericMinmax(minmax, item, minmaxType);
        }
        return minmax;
    }

    private Atomic genericMinmax(Atomic minmax, Item item, Type minmaxType) throws QueryException {
        Atomic s = item.atomize();
        Type type = s.type();
        if (!type.instanceOf(minmaxType)) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Incomparable types in aggregate function: %s and %s.", minmaxType, type);
        }
        int res = minmax.cmp(s);
        if (this.min ? res > 0 : res < 0) {
            minmax = s;
        }
        return minmax;
    }

    private Atomic stringMinmax(Iter in, Atomic minmax) throws QueryException {
        Item item;
        Type minmaxType = minmax.type().getPrimitiveBase();
        while ((item = in.next()) != null) {
            minmax = this.stringMinmax(minmax, item, minmaxType);
        }
        return minmax;
    }

    private Atomic stringMinmax(Atomic minmax, Item item, Type minmaxType) throws QueryException {
        Atomic s = item.atomize();
        Type type = s.type();
        if (type == Type.AURI) {
            s = Cast.cast(null, s, Type.STR, false);
            type = Type.STR;
        } else if (!type.instanceOf(Type.STR)) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Incomparable types in aggregate function: %s and %s.", minmaxType, type);
        }
        int res = minmax.cmp(s);
        if (this.min ? res > 0 : res < 0) {
            minmax = s;
        }
        return minmax;
    }

    private Atomic numericMinmax(Iter in, Atomic minmax) throws QueryException {
        Item item;
        Type minmaxType = minmax.type();
        while ((item = in.next()) != null) {
            minmax = this.numericMinmax(minmax, item, minmaxType);
        }
        return minmax;
    }

    private Atomic numericMinmax(Atomic minmax, Item item, Type minmaxType) throws QueryException {
        Atomic s = item.atomize();
        Type type = s.type();
        if (type == Type.UNA) {
            s = Cast.cast(null, s, Type.DBL, false);
            type = Type.DBL;
        }
        if (!(s instanceof Numeric)) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Incomparable types in aggregate function: %s and %s.", minmaxType, type);
        }
        int res = minmax.cmp(s);
        if (this.min ? res > 0 : res < 0) {
            minmax = s;
        }
        return minmax;
    }

    private static enum AggType {
        NUMERIC,
        STRING,
        GENERIC;

    }
}

