/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.aggregator;

import java.util.Arrays;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.sequence.NestedSequence;
import org.brackit.xquery.util.aggregator.Aggregator;
import org.brackit.xquery.xdm.Sequence;

public class SequenceAggregator
implements Aggregator {
    private Sequence[] buf = new Sequence[5];
    private int len;

    @Override
    public void add(Sequence s) throws QueryException {
        if (s == null) {
            return;
        }
        if (this.len == this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length * 3 / 2 + 1);
        }
        this.buf[this.len++] = s;
    }

    @Override
    public Sequence getAggregate() {
        if (this.len == 0) {
            return null;
        }
        if (this.len == 1) {
            return this.buf[0];
        }
        if (this.buf.length != this.len) {
            this.buf = Arrays.copyOf(this.buf, this.len);
        }
        return new NestedSequence(this.buf);
    }

    @Override
    public void clear() {
        if (this.len > 1) {
            this.buf = new Sequence[5];
        }
        this.len = 0;
    }
}

