/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.dot;

import java.util.ArrayList;
import java.util.List;
import org.brackit.xquery.util.dot.DotContext;

public class DotNode {
    final String name;
    final List<Row> rows = new ArrayList<Row>();

    DotNode(String name) {
        this.name = name;
    }

    public void addRow(String port, String name, String value) {
        this.rows.add(new Row(port, name, value));
    }

    public void addRow(String name, String value) {
        this.rows.add(new Row(null, name, value));
    }

    public void addRow(String name, int value) {
        this.rows.add(new Row(null, name, String.valueOf(value)));
    }

    public void addRow(String name, long value) {
        this.rows.add(new Row(null, name, String.valueOf(value)));
    }

    public void addRow(String name, double value) {
        this.rows.add(new Row(null, name, String.format("%.3f", value)));
    }

    public String toDotString() {
        Object head = String.format("%s [ label=<<TABLE PORT=\"port\" BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" ALIGN=\"CENTER\">", DotContext.maskHTML(this.name));
        for (Row r : this.rows) {
            if (r.value != null) {
                head = (String)head + String.format("<TR><TD>%s</TD><TD>%s</TD></TR>", DotContext.maskHTML(r.name), DotContext.maskHTML(r.value));
                continue;
            }
            head = (String)head + String.format("<TR><TD COLSPAN=\"2\">%s</TD></TR>", DotContext.maskHTML(r.name));
        }
        head = (String)head + "</TABLE>>];";
        return head;
    }

    private static class Row {
        final String port;
        final String name;
        final String value;

        Row(String port, String name, String value) {
            this.port = port;
            this.name = name;
            this.value = value;
        }
    }
}

