/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;

public class IOUtils {
    public static PrintStream createBuffer() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        return new PrintStream(out){
            final OutputStream baos;
            {
                this.baos = this.out;
            }

            public String toString() {
                return this.baos.toString();
            }
        };
    }

    public static String getMd5(String pInput) {
        try {
            MessageDigest lDigest = MessageDigest.getInstance("MD5");
            lDigest.update(pInput.getBytes());
            BigInteger lHashInt = new BigInteger(1, lDigest.digest());
            return String.format("%1$032X", lHashInt);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static FileFilter nameFilter(final String pattern) {
        return new FileFilter(){
            final String p;
            {
                this.p = pattern;
            }

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().matches(this.p);
            }
        };
    }

    public static List<File> getFilteredFileListing(File dir, FileFilter fileFilter) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        List<File> filesDirs = Arrays.asList(dir.listFiles());
        for (File file : filesDirs) {
            if (file != null && fileFilter.accept(file)) {
                result.add(file);
            }
            if (!file.isDirectory()) continue;
            result.addAll(IOUtils.getFilteredFileListing(file, fileFilter));
        }
        return result;
    }

    public static List<File> getFoldersFileListing(File dir) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        List<File> filesDirs = Arrays.asList(dir.listFiles());
        for (File file : filesDirs) {
            if (!file.isDirectory() || file.getName().startsWith(".svn")) continue;
            result.add(file);
        }
        return result;
    }

    public static String getNormalizedPath(File f) {
        return f.getPath().replaceAll(Pattern.quote(File.separator), "/");
    }

    public static String getStringFromFile(File pFile) throws QueryException {
        byte[] buffer = new byte[(int)pFile.length()];
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(pFile));
            in.read(buffer);
        }
        catch (IOException e) {
            throw new QueryException(e, ErrorCode.ERR_PARSING_ERROR, (Object)e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(buffer);
    }

    public static String getStringFromInputStream(InputStream in) throws QueryException {
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        try {
            int n;
            while ((n = in.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
        }
        catch (IOException e) {
            throw new QueryException(e, ErrorCode.ERR_PARSING_ERROR, (Object)e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return out.toString();
    }
}

