/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.brackit.xquery.util.io.URLInputStream;
import org.brackit.xquery.util.io.URLOutputStream;

public class URIHandler {
    public static final int TIMEOUT = 2000;

    public static OutputStream getOutputStream(String uri, boolean overwrite) throws IOException {
        try {
            return URIHandler.getOutputStream(new URI(uri), overwrite);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid resource URI: " + uri, e);
        }
    }

    public static OutputStream getOutputStream(URI uri, boolean overwrite) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            File f;
            String fullPath = uri.getSchemeSpecificPart();
            if (fullPath == null) {
                throw new IOException(String.format("Illegal file name: %s", uri));
            }
            if (fullPath.startsWith("//")) {
                fullPath = fullPath.substring(1);
            }
            if ((f = new File(fullPath)).exists() && !f.isFile()) {
                throw new IOException(String.format("Location is not a file: %s", uri));
            }
            if (overwrite) {
                if (f.exists()) {
                    f.delete();
                }
                f.createNewFile();
            }
            return new FileOutputStream(f);
        }
        if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ftp") || scheme.equals("jar")) {
            URL url = uri.toURL();
            return new URLOutputStream(url, 2000);
        }
        throw new IOException(String.format("Unsupported protocol: %s", scheme));
    }

    public static InputStream getInputStream(String uri) throws IOException {
        try {
            return URIHandler.getInputStream(new URI(uri));
        }
        catch (URISyntaxException e) {
            return Files.newInputStream(Paths.get(uri, new String[0]), new OpenOption[0]);
        }
    }

    public static InputStream getInputStream(URI uri) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            String fullPath = uri.getSchemeSpecificPart();
            if (fullPath == null) {
                throw new IOException(String.format("Illegal file name: %s", uri));
            }
            if (fullPath.startsWith("//")) {
                fullPath = fullPath.substring(1);
            }
            return new FileInputStream(new File(fullPath));
        }
        if (scheme.equals("http") || scheme.equals("https") || scheme.equals("ftp") || scheme.equals("jar")) {
            return new URLInputStream(uri.toURL(), 2000);
        }
        throw new IOException(String.format("Unsupported protocol: %s", scheme));
    }

    public static URI getURIForFileName(String path) throws URISyntaxException {
        return new URI("file", null, path, null);
    }

    public static URI getURIForFile(File file) {
        return file.toURI();
    }
}

