/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class URLInputStream
extends InputStream {
    private final URLConnection conn;
    private final InputStream in;

    public URLInputStream(URL url) throws IOException {
        this.conn = url.openConnection();
        this.in = this.conn.getInputStream();
    }

    public URLInputStream(URL url, int timeout) throws IOException {
        this.conn = url.openConnection();
        this.conn.setConnectTimeout(timeout);
        this.in = this.conn.getInputStream();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (this.conn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.conn).disconnect();
        }
    }
}

