/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class URLOutputStream
extends OutputStream {
    private final URLConnection conn;
    private final OutputStream out;

    public URLOutputStream(URL url) throws IOException {
        this.conn = url.openConnection();
        this.out = this.conn.getOutputStream();
    }

    public URLOutputStream(URL url, int timeout) throws IOException {
        this.conn = url.openConnection();
        this.conn.setConnectTimeout(timeout);
        this.out = this.conn.getOutputStream();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (this.conn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.conn).disconnect();
        }
    }
}

