/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.join;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.util.join.FastList;
import org.brackit.xquery.util.join.JoinTable;
import org.brackit.xquery.xdm.Sequence;

public class HashJoinTable
extends JoinTable {
    private final HashMap<JoinTable.TKey, JoinTable.TValue> table = new HashMap();

    @Override
    protected void add(Atomic key, int pos, Sequence[] bindings) throws QueryException {
        JoinTable.TKey htKey = new JoinTable.TKey(key);
        JoinTable.TValue htValue = new JoinTable.TValue(bindings, pos);
        JoinTable.TValue chain = this.table.get(htKey);
        if (chain == null) {
            this.table.put(htKey, htValue);
        } else {
            JoinTable.TValue p = null;
            while (chain != null) {
                if (chain.pos == pos) {
                    return;
                }
                p = chain;
                chain = chain.next;
            }
            p.next = htValue;
        }
    }

    @Override
    protected void lookup(FastList<JoinTable.TValue> matches, Atomic key) throws QueryException {
        JoinTable.TKey htKey = new JoinTable.TKey(key);
        JoinTable.TValue htValue = this.table.get(htKey);
        if (htValue != null) {
            while (htValue != null) {
                matches.add(htValue);
                htValue = htValue.next;
            }
        }
    }

    @Override
    protected List<JoinTable.TEntry> entries() {
        ArrayList<JoinTable.TEntry> entries = new ArrayList<JoinTable.TEntry>();
        for (Map.Entry<JoinTable.TKey, JoinTable.TValue> entry : this.table.entrySet()) {
            JoinTable.TValue v = entry.getValue();
            while (v != null) {
                entries.add(new JoinTable.TEntry(entry.getKey(), v));
                v = v.next;
            }
        }
        return entries;
    }
}

