/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.join;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.expr.Cast;
import org.brackit.xquery.util.Cmp;
import org.brackit.xquery.util.join.FastList;
import org.brackit.xquery.util.join.HashJoinTable;
import org.brackit.xquery.util.join.JoinTable;
import org.brackit.xquery.util.join.SortedJoinTable;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Type;

public class MultiTypeJoinTable {
    private final Cmp cmp;
    private final boolean isGCmp;
    private final boolean skipSort;
    private final Map<Type, JoinTable> tables = new HashMap<Type, JoinTable>();
    private final Set<Type> convertedUntypedAtomic = new HashSet<Type>();
    private final Set<Type> nonNumericTypes = new HashSet<Type>();
    private boolean convertedUntypedAtomicToDbl;
    private boolean promotedNumericToDbl;
    private boolean promotedNumericToFlo;
    private boolean promotedNumericToDec;
    private boolean numericPresent;

    public MultiTypeJoinTable(Cmp cmp, boolean isGCmp, boolean skipSort) {
        this.cmp = cmp;
        this.isGCmp = isGCmp;
        this.skipSort = skipSort;
    }

    private JoinTable createTable(Type type) {
        return this.cmp == Cmp.eq ? new HashJoinTable() : new SortedJoinTable(this.cmp);
    }

    private void addItem(Item key, Sequence[] bindings, int pos) throws QueryException {
        JoinTable table;
        Atomic atomic = key.atomize();
        Type type = atomic.type().getPrimitiveBase();
        if (!this.isGCmp && type == Type.UNA) {
            atomic = Cast.cast(null, atomic, Type.STR, false);
            type = Type.STR;
        }
        if ((table = this.tables.get(type)) == null) {
            table = this.createTable(type);
            this.tables.put(type, table);
        }
        table.add(atomic, pos, bindings);
        if (type.isNumeric()) {
            this.numericPresent = true;
        } else {
            this.nonNumericTypes.add(type);
        }
    }

    private void probeItem(FastList<JoinTable.TValue> matches, Item key) throws QueryException {
        Atomic atomic = key.atomize();
        Type type = atomic.type().getPrimitiveBase();
        if (!this.isGCmp && type == Type.UNA) {
            atomic = Cast.cast(null, atomic, Type.STR, false);
            type = Type.STR;
        }
        if (type == Type.UNA) {
            for (Type nnType : this.nonNumericTypes) {
                this.probeAtomic(matches, Cast.cast(null, atomic, nnType, false), nnType);
            }
            if (this.numericPresent) {
                if (!this.promotedNumericToDbl) {
                    this.addToTable(Type.INR, Type.DBL);
                    this.addToTable(Type.DEC, Type.DBL);
                    this.addToTable(Type.FLO, Type.DBL);
                    this.promotedNumericToDbl = true;
                }
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DBL, false), Type.DBL);
            }
        } else if (type.isNumeric()) {
            if (!this.convertedUntypedAtomicToDbl) {
                this.addToTable(Type.UNA, Type.DBL);
                this.convertedUntypedAtomicToDbl = true;
            }
            if (type == Type.DBL && !this.promotedNumericToDbl) {
                this.addToTable(Type.INR, Type.DBL);
                this.addToTable(Type.DEC, Type.DBL);
                this.addToTable(Type.FLO, Type.DBL);
                this.promotedNumericToDbl = true;
            } else if (type == Type.FLO && !this.promotedNumericToFlo) {
                this.addToTable(Type.INR, Type.FLO);
                this.addToTable(Type.DEC, Type.FLO);
                this.promotedNumericToFlo = true;
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DBL, false), Type.DBL);
            } else if (type == Type.DEC && !this.promotedNumericToDec) {
                this.addToTable(Type.INR, Type.DEC);
                this.promotedNumericToDec = true;
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DBL, false), Type.DBL);
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.FLO, false), Type.FLO);
            } else if (type == Type.INR) {
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DBL, false), Type.DBL);
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.FLO, false), Type.FLO);
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.DEC, false), Type.DEC);
            }
            this.probeAtomic(matches, atomic, type);
        } else {
            if (!this.convertedUntypedAtomic.contains(type)) {
                this.addToTable(Type.UNA, type);
                this.convertedUntypedAtomic.add(type);
            }
            this.probeAtomic(matches, atomic, type);
            if (type == Type.STR) {
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.AURI, false), Type.AURI);
            } else if (type == Type.AURI) {
                this.probeAtomic(matches, Cast.cast(null, atomic, Type.STR, false), Type.STR);
            }
        }
    }

    private void addToTable(Type from, Type to) throws QueryException {
        JoinTable fromTable = this.tables.get(from);
        if (fromTable == null) {
            return;
        }
        JoinTable table = this.tables.get(to);
        if (table == null) {
            table = this.createTable(to);
            this.tables.put(to, table);
        }
        for (JoinTable.TEntry entry : fromTable.entries()) {
            table.add(Cast.cast(null, entry.key.atomic, to, false), entry.value.pos, entry.value.bindings);
        }
        if (to.isNumeric()) {
            this.numericPresent = true;
        } else {
            this.nonNumericTypes.add(to);
        }
    }

    private void probeAtomic(FastList<JoinTable.TValue> matches, Atomic atomic, Type type) throws QueryException {
        JoinTable table = this.tables.get(type);
        if (table != null) {
            table.lookup(matches, atomic);
        }
    }

    protected final FastList<Sequence[]> sortAndDeduplicate(FastList<JoinTable.TValue> in) throws QueryException {
        int inSize = in.getSize();
        if (this.skipSort || inSize < 2) {
            FastList<Sequence[]> out = new FastList<Sequence[]>(inSize);
            for (int i = 0; i < inSize; ++i) {
                out.add(in.get((int)i).bindings);
            }
            return out;
        }
        in.sort();
        FastList<Sequence[]> out = new FastList<Sequence[]>();
        JoinTable.TValue p = null;
        for (int i = 0; i < inSize; ++i) {
            JoinTable.TValue v = in.get(i);
            if (p == null || p.pos < v.pos) {
                out.add(v.bindings);
            }
            p = v;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(Sequence keys, Sequence[] bindings, int pos) throws QueryException {
        if (keys == null) {
            return;
        }
        if (keys instanceof Item) {
            this.addItem((Item)keys, bindings, pos);
        } else {
            try (Iter it = keys.iterate();){
                Item key;
                while ((key = it.next()) != null) {
                    this.addItem(key, bindings, pos);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FastList<Sequence[]> probe(Sequence keys) throws QueryException {
        if (keys == null) {
            return FastList.emptyList();
        }
        FastList<JoinTable.TValue> matches = new FastList<JoinTable.TValue>();
        if (keys instanceof Item) {
            this.probeItem(matches, (Item)keys);
        } else {
            try (Iter it = keys.iterate();){
                Item key;
                while ((key = it.next()) != null) {
                    this.probeItem(matches, key);
                }
            }
        }
        if (matches.isEmpty()) {
            return FastList.emptyList();
        }
        return this.sortAndDeduplicate(matches);
    }
}

