/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.join;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.util.join.FastList;
import org.brackit.xquery.util.join.JoinTable;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;

public class SingleTypeJoinTable {
    protected final QueryContext ctx;
    protected final JoinTable table;

    public SingleTypeJoinTable(QueryContext ctx, JoinTable table) {
        this.ctx = ctx;
        this.table = table;
    }

    protected final FastList<Sequence[]> sortAndDeduplicate(FastList<JoinTable.TValue> in) throws QueryException {
        in.sort();
        FastList<Sequence[]> out = new FastList<Sequence[]>();
        JoinTable.TValue p = null;
        int inSize = in.getSize();
        for (int i = 0; i < inSize; ++i) {
            JoinTable.TValue v = in.get(i);
            if (p == null || p.pos < v.pos) {
                out.add(v.bindings);
            }
            p = v;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(Sequence keys, Sequence[] bindings, int pos) throws QueryException {
        if (keys instanceof Item) {
            this.table.add(((Item)keys).atomize(), pos, bindings);
        } else {
            try (Iter it = keys.iterate();){
                Item key;
                while ((key = it.next()) != null) {
                    this.table.add(key.atomize(), pos, bindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FastList<Sequence[]> probe(Sequence keys) throws QueryException {
        if (keys == null) {
            return FastList.emptyList();
        }
        FastList<JoinTable.TValue> matches = new FastList<JoinTable.TValue>();
        if (keys instanceof Item) {
            this.table.lookup(matches, ((Item)keys).atomize());
        } else {
            try (Iter it = keys.iterate();){
                Item key;
                while ((key = it.next()) != null) {
                    this.table.lookup(matches, key.atomize());
                }
            }
        }
        if (matches.isEmpty()) {
            return FastList.emptyList();
        }
        return this.sortAndDeduplicate(matches);
    }
}

