/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.join;

import java.util.Arrays;
import java.util.List;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.util.Cmp;
import org.brackit.xquery.util.join.FastList;
import org.brackit.xquery.util.join.JoinTable;
import org.brackit.xquery.xdm.Sequence;

public class SortedJoinTable
extends JoinTable {
    private final Cmp cmp;
    private JoinTable.TEntry[] entries = new JoinTable.TEntry[50];
    private int size;
    private boolean sorted;

    public SortedJoinTable(Cmp cmp) {
        this.cmp = cmp;
    }

    @Override
    protected void add(Atomic key, int pos, Sequence[] bindings) throws QueryException {
        if (this.size == this.entries.length) {
            this.entries = Arrays.copyOf(this.entries, this.entries.length * 3 / 2 + 1);
        }
        this.entries[this.size++] = new JoinTable.TEntry(new JoinTable.TKey(key), new JoinTable.TValue(bindings, pos));
    }

    @Override
    protected void lookup(FastList<JoinTable.TValue> matches, Atomic key) throws QueryException {
        if (!this.sorted) {
            Arrays.sort(this.entries, 0, this.size);
            this.sorted = true;
        }
        if (this.cmp == Cmp.eq) {
            this.equalLookup(matches, key);
        } else if (this.cmp == Cmp.le || this.cmp == Cmp.lt) {
            this.lessLookup(matches, key);
        } else if (this.cmp == Cmp.ge || this.cmp == Cmp.gt) {
            this.greaterLookup(matches, key);
        } else {
            throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR);
        }
    }

    private void lessLookup(FastList<JoinTable.TValue> matches, Atomic key) {
        JoinTable.TKey tKey = new JoinTable.TKey(key);
        int lower = 0;
        int upper = this.size - 1;
        while (lower < upper) {
            int mid = lower + (upper - lower) / 2;
            int p = this.entries[mid].key.compareTo(tKey);
            if (this.cmp == Cmp.le && p >= 0 || p > 0) {
                upper = mid;
                continue;
            }
            lower = mid + 1;
        }
        matches.ensureAdditional(this.size - lower);
        for (int i = lower; i < this.size; ++i) {
            matches.addUnchecked(this.entries[i].value);
        }
    }

    private void greaterLookup(FastList<JoinTable.TValue> matches, Atomic key) {
        JoinTable.TKey tKey = new JoinTable.TKey(key);
        int lower = 0;
        int upper = this.size - 1;
        while (lower < upper) {
            int mid = lower + (upper - lower + 1) / 2;
            int p = this.entries[mid].key.compareTo(tKey);
            if (this.cmp == Cmp.gt && p >= 0 || p > 0) {
                upper = mid - 1;
                continue;
            }
            lower = mid;
        }
        matches.ensureAdditional(lower + 1);
        for (int i = 0; i < lower + 1; ++i) {
            matches.addUnchecked(this.entries[i].value);
        }
    }

    private void equalLookup(FastList<JoinTable.TValue> matches, Atomic key) {
        JoinTable.TKey tKey = new JoinTable.TKey(key);
        int res = -1;
        int lower = 0;
        int upper = this.size - 1;
        int pos = 0;
        while (lower <= upper) {
            pos = lower + (upper - lower) / 2;
            res = this.entries[pos].key.compareTo(tKey);
            if (res == 0) break;
            if (res < 0) {
                lower = pos + 1;
                continue;
            }
            upper = pos - 1;
        }
        if (res != 0) {
            return;
        }
        int i = pos;
        do {
            matches.add(this.entries[i].value);
        } while (++i < this.size && this.entries[i].key.compareTo(tKey) == 0);
        i = pos - 1;
        while (i >= 0 && this.entries[i].key.compareTo(tKey) == 0) {
            matches.add(this.entries[i--].value);
        }
    }

    @Override
    protected List<JoinTable.TEntry> entries() {
        return Arrays.asList(Arrays.copyOfRange(this.entries, 0, this.size));
    }
}

