/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.log;

import org.brackit.xquery.util.Cfg;
import org.brackit.xquery.util.log.LogFactory;
import org.brackit.xquery.util.log.UtilLogFactory;

public abstract class Logger {
    private static LogFactory factory;

    public static Logger getRootLogger() {
        return factory.getRootLogger();
    }

    public static Logger getLogger(String name) {
        return factory.getLogger(name);
    }

    public static Logger getLogger(Class<?> cls) {
        return Logger.getLogger(cls.getName());
    }

    public abstract void setLevel(Level var1);

    public abstract Level getLevel();

    public abstract boolean isTraceEnabled();

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract void log(Level var1, Object var2, Throwable var3);

    public abstract void log(Level var1, Object var2);

    public abstract String getName();

    public void trace(Object msg) {
        this.log(Level.TRACE, msg);
    }

    public void trace(Object msg, Throwable t) {
        this.log(Level.TRACE, msg, t);
    }

    public void debug(Object msg) {
        this.log(Level.DEBUG, msg);
    }

    public void debug(Object msg, Throwable t) {
        this.log(Level.DEBUG, msg, t);
    }

    public void info(Object msg) {
        this.log(Level.INFO, msg);
    }

    public void info(Object msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    public void warn(Object msg) {
        this.log(Level.WARN, msg);
    }

    public void warn(Object msg, Throwable t) {
        this.log(Level.WARN, msg, t);
    }

    public void error(Object msg) {
        this.log(Level.ERROR, msg);
    }

    public void error(Object msg, Throwable t) {
        this.log(Level.ERROR, msg, t);
    }

    public void fatal(Object msg) {
        this.log(Level.FATAL, msg);
    }

    public void fatal(Object msg, Throwable t) {
        this.log(Level.FATAL, msg, t);
    }

    static {
        String useLog = Cfg.asString(LogFactory.class.getName(), UtilLogFactory.class.getName());
        try {
            factory = (LogFactory)Class.forName(useLog).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Level {
        TRACE(0),
        DEBUG(1),
        INFO(2),
        WARN(3),
        ERROR(4),
        FATAL(5);

        public final int priority;

        private Level(int prioprity) {
            this.priority = prioprity;
        }
    }
}

