/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.util.log;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.brackit.xquery.util.log.Logger;

public class UtilLogger
extends Logger {
    private java.util.logging.Logger log;
    private Level[] map = new Level[]{Level.FINER, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.SEVERE};

    public UtilLogger(java.util.logging.Logger log) {
        this.log = log;
    }

    @Override
    public String getName() {
        return this.log.getName();
    }

    @Override
    public void log(Logger.Level level, Object msg) {
        UtilLogRecord record = new UtilLogRecord(this.map[level.priority], msg != null ? msg.toString() : null);
        this.log.log(record);
    }

    @Override
    public void log(Logger.Level level, Object msg, Throwable t) {
        UtilLogRecord record = new UtilLogRecord(this.map[level.priority], msg != null ? msg.toString() : null);
        record.setThrown(t);
        this.log.log(record);
    }

    @Override
    public void setLevel(Logger.Level level) {
        this.log.setLevel(this.map[level.priority]);
    }

    @Override
    public Logger.Level getLevel() {
        Level level = this.log.getLevel();
        if (level == Level.FINER) {
            return Logger.Level.TRACE;
        }
        if (level == Level.FINE) {
            return Logger.Level.DEBUG;
        }
        if (level == Level.INFO) {
            return Logger.Level.INFO;
        }
        if (level == Level.WARNING) {
            return Logger.Level.WARN;
        }
        if (level == Level.SEVERE) {
            return Logger.Level.ERROR;
        }
        return Logger.Level.ERROR;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isLoggable(Level.FINER);
    }

    private static class UtilLogRecord
    extends LogRecord {
        public UtilLogRecord(Level level, String msg) {
            super(level, msg);
            this.inferCaller(UtilLogger.class, this);
        }

        private void inferCaller(Class<?> clazz, LogRecord lrec) {
            String cname;
            int i;
            StackTraceElement[] stack = new Throwable().getStackTrace();
            StackTraceElement frame = null;
            String wcname = clazz.getName();
            for (i = 0; i < stack.length && !(cname = (frame = stack[i]).getClassName()).equals(wcname); ++i) {
            }
            if (i < stack.length - 2) {
                frame = stack[i + 2];
                lrec.setSourceClassName(frame.getClassName());
                lrec.setSourceMethodName(frame.getMethodName());
            }
        }
    }
}

